/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXEDIT_UI_CLEAVE_RESULTS_H
#define POLYXEDIT_UI_CLEAVE_RESULTS_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxmass-window-mngmt.h"



GtkWidget *
polyxedit_cleave_res_wnd_setup (PxmEditCtxt *editctxt,
				    GPtrArray *partialsGPA);
void
polyxedit_cleave_res_wnd_update_cleavage_data (GtkWidget *window);

gboolean
polyxedit_cleave_res_wnd_show_oligs (GtkWidget *window,
				     GPtrArray *partialsGPA);
void
polyxedit_cleave_res_wnd_update_cleavage_data (GtkWidget *window);

gboolean
polyxedit_cleave_res_setup_oligs_treeview (GtkWidget *window, 
						   GtkWidget *vbox);

GtkTreeModel *
polyxedit_cleave_res_create_oligs_treeview_model (GPtrArray *GPA);

void
polyxedit_cleave_res_oligs_treeview_row_activated (GtkTreeView *treeview,
						   GtkTreePath *arg1,
						   GtkTreeViewColumn *arg2,
						   gpointer data);

void
polyxedit_cleave_res_oligs_treeview_selection_changed (GtkTreeSelection *
						       selection,
						       gpointer data);

void   
polyxedit_cleave_res_oligs_treeview_column_clicked (GtkTreeViewColumn *
						    treeviewcolumn,
						    gpointer data);

gboolean
polyxedit_cleave_res_setup_oligomer_modifs_treeview (GtkWidget *window,
						     GtkWidget *vbox);

void
polyxedit_cleave_res_olig_show_data (PxmOligomer *oligomer,
				     GtkWidget *window);

void
polyxedit_cleave_res_olig_show_modification_data (PxmOligomer *oligomer,
						  GtkWidget *window);

gint
polyxedit_cleave_results_wnd_sort_mass_column (GtkTreeModel *model,
					      GtkTreeIter *a,
					      GtkTreeIter *b,
					      gpointer data);

void
polyxedit_cleave_results_wnd_find_button (GtkWidget *widget, gpointer data);


gint
polyxedit_cleave_res_wnd_sort_coordinates_column (GtkTreeModel *model,
						  GtkTreeIter *a,
						  GtkTreeIter *b,
						  gpointer user_data);

gint
polyxedit_cleave_res_wnd_sort_name_column (GtkTreeModel *model,
						  GtkTreeIter *a,
						  GtkTreeIter *b,
						  gpointer user_data);




/* REPORTING FUNCTIONS.
 */
extern gchar *
polyxedit_cleave_results_wnd_make_report (PxmReportOpt* reportopt,
					    PxmWinMngmt* winmngmt);

gchar *
polyxedit_cleave_results_wnd_make_report_text_format (PxmReportOpt* reportopt,
						      PxmWinMngmt* winmngmt);

gchar *
polyxedit_cleave_results_wnd_make_report_latex_format (PxmReportOpt* 
						       reportopt,
						       PxmWinMngmt* winmngmt);




/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_cleave_res_wnd_really_close (GtkWidget *window);

gboolean
polyxedit_cleave_res_wnd_delete_event (GtkWidget *window,
				       GdkEvent *event,
				       gpointer data);

gboolean
polyxedit_cleave_res_wnd_destroy_event (GtkWidget *window,
					GdkEvent *event,
					gpointer data);







#endif /*POLYXEDIT_UI_CLEAVE_RESULTS_H */
