/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXEDIT_UI_MONOMER_MODIF_H
#define POLYXEDIT_UI_MONOMER_MODIF_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"

enum
  {
    MODIF_TARGET_SEL_MONOMER,
    MODIF_TARGET_ALL_MONOMERS,
    MODIF_TARGET_ALL_MONOMERS_CODE,
    MODIF_TARGET_ALL_MONOMERS_LIST,
    MODIF_TARGET_SPEC_POS_MONOMERS
  };


GtkWidget *
polyxedit_ui_monomer_modif_setup_wnd (PxmEditCtxt *editctxt);


gboolean
polyxedit_ui_monomer_modif_setup_modifs_treeview (GtkTreeView *treeview,
						  PxmPolchemdef *polchemdef);

gboolean
polyxedit_ui_monomer_modif_setup_monomcodes_treeview (GtkTreeView *treeview,
						      PxmPolchemdef *polchemdef);

void
polyxedit_ui_monomer_modif_modify_button (GtkWidget *button,
					  gpointer data);

void
polyxedit_ui_monomer_modif_un_modify_button (GtkWidget *button,
					     gpointer data);

gint
polyxedit_ui_monomer_modif_prepare_indices_array (GtkWidget *window,
						  GArray *GA);

gint
polyxedit_ui_monomer_modif_get_target (GtkWidget *window);








/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
void
polyxedit_ui_monomer_modif_wnd_really_close (GtkWidget *window);

gboolean
polyxedit_ui_monomer_modif_wnd_delete_event (GtkWidget *window, 
					     GdkEventAny *event, 
					     gpointer data);

gboolean
polyxedit_ui_monomer_modif_wnd_destroy_event (GtkWidget *window, 
					      GdkEventAny *event, 
					      gpointer data);

#endif /* POLYXEDIT_UI_MONOMER_MODIF_H */
