/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef POLYXMASS_POLCHEMDEFCTXT_H
#define POLYXMASS_POLCHEMDEFCTXT_H

#include "polyxmass-globals.h"


typedef struct _PxmPolchemdefCtxt PxmPolchemdefCtxt;


struct _PxmPolchemdefCtxt
{
  /* Polymer definition instance that holds all the polymer chemistry
   * data.
   */
  PxmPolchemdef *polchemdef;

  /* Array of PxmMonomerSpec instances to hold the correspondences
     between a given monomer code and the graphic files used to
     display it in the seqeditor window, but also to hold the
     correspondence between a monomer code/name pair and the
     corresponding sound file names.
   */
  GPtrArray *mnmspecGPA;

  /* Array of PxmModifSpec instances to hold the correspondences
     between a given modification name and the graphic files used to
     render it in the seqeditor window, but also to hold the
     correspondence between a modification name and its corresponding
     sound file name.
   */
  GPtrArray *mdfspecGPA;

  /* We want to store the pointer of each GdkPixbuf (monomer icon,
   * which is also true for modif icons) that is made while loading or
   * editing a polymer, so that we can access it easily if more than
   * one given monomer is present in the polymer sequence : we use a
   * keyed datalist GData which we will fill with GQuark made from the
   * code string identifying a given monomer for current
   * polchemdefctxt.
   */
  GData *pixbufGData;

  /* We want to store the pointer of each monomer name/code sound data
     as well as modifications' name sound data; these sound data are
     read from disk while making a sound file corresponding to a
     polymer sequence region in the editor. Since the sound files read
     from disk will be the same whatever the polymer sequence, if that
     sequence is of the same polymer chemistry definition as the one
     here (member datum polchemdef), we store those data here so that
     they are available for any sequence of the same polymer chemistry
     definition. We use a keyed datalist GData which we will fill with
     GQuark made from the name string identifying a given
     monomer/modif for current polchemdefctxt.
   */
  GData *mnm_mdf_soundsGData;

  /* Count of polymer sequences of this polchemdefctxt that are currently
   * opened.
   */
  gint refcount;

  /* The conventional system of prop array.
   */
  GPtrArray *propGPA;
};



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmPolchemdefCtxt *
polyxmass_polchemdefctxt_new (void);

gboolean
polyxmass_polchemdefctxt_init_with_type (PxmPolchemdefCtxt *polchemdefctxt,
					 gchar *type, gboolean with_atoms);



/*  LOCATING FUNCTIONS
 */
gint
polyxmass_polchemdefctxt_get_index_by_type (GPtrArray *GPA, gchar *type);
gint
polyxmass_polchemdefctxt_get_index (GPtrArray *GPA, 
				    PxmPolchemdefCtxt *pdfctxt);

PxmPolchemdefCtxt *
polyxmass_polchemdefctxt_get_ptr_by_type (gchar *type, GPtrArray *GPA);



/* REFERENCE COUNTING MANAGEMENT
 */
gint
polyxmass_polchemdefctxt_ref (PxmPolchemdefCtxt *pdfctxt);

gint
polyxmass_polchemdefctxt_unref (PxmPolchemdefCtxt *pdfctxt);

gint
polyxmass_polchemdefctxt_ref_from_type (GPtrArray *GPA, gchar *type);

gint
polyxmass_polchemdefctxt_unref_from_type (GPtrArray *GPA,gchar *type);

gint
polyxmass_polchemdefctxt_remove_from_GPA (GPtrArray *GPA, 
				      PxmPolchemdefCtxt *pdfctxt);



/* FREE'ING FUNCTIONS
 */
gboolean
polyxmass_polchemdefctxt_free (PxmPolchemdefCtxt *pdfctxt);

void 
polyxmass_polchemdefctxt_unref_last_pixbuf_from_gdata (GQuark quarkId,
						       gpointer gdata,
						       gpointer data);




/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxmass_polchemdefctxt_GPA_free (GPtrArray *GPA);







#endif /*POLYXMASS_POLCHEMDEFCTXT_H*/
