/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/
#ifndef POLYXMASS_WINDOW_MGMT_H
#define POLYXMASS_WINDOW_MGMT_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"


typedef struct _PxmWinMngmt PxmWinMngmt;


struct _PxmWinMngmt
{
  /* The name of the module in which this window was creaed.
   */
  gchar *module;
  
  /* The pointer to the window being documented with this structure.
   */
  GtkWidget *wnd;
  
  /* The editor window to which this 'wnd' window is dependent.
   */
  GtkWidget *sequence_editor_wnd;

  /* The name of the polymer sequence that's displayed in the sequence
     editor window. NOT ALLOCATED. Points to
     editctxt->polymer->plminfo->name.
  */
  gchar *sequence_name;
    
  /* The window that can be called the parent window of this 'wnd'
     window.
  */
  GtkWidget *parent_wnd;

  /* The editor context to which this 'wnd' window belongs to.
   */
  PxmEditCtxt *editctxt;
  
  /* A standard string describing what this window is for. This is 
     a string like "CLEAVE_RESULTS" or "ELEMENTAL_COMPOSITION"...
  */
  gchar *desc;
  
  /* A string that will tell more details about the reasons the window
     has been created for.
  */
  gchar *comment;
  
  /* Boolean that will be set to TRUE if the contents of the window
     can be reported (in a text or LaTeX string, for example).
  */
  gboolean can_report;

  gchar *(*make_report) (PxmReportOpt *reportopt, PxmWinMngmt* winmngmt);
};




/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS, COPYING FUNCTIONS ...
 */
PxmWinMngmt*
polyxmass_winmngmt_new (void);


PxmWinMngmt*
polyxmass_winmngmt_copy (PxmWinMngmt* dest, PxmWinMngmt* src);



/* DATA-MODIFYING FUNCTIONS
 */
gchar *
polyxmass_winmngmt_set_desc (PxmWinMngmt* winmngmt, gchar *desc);

gchar *
polyxmass_winmngmt_set_comment (PxmWinMngmt* winmngmt, gchar *comment);




/*  LOCATING FUNCTIONS
 */
PxmWinMngmt*
polyxmass_winmngmt_find_registered_window (GtkWidget *wnd,
					   gchar *module);

GPtrArray*
polyxmass_winmngmt_find_module_GPA (gchar *module);


PxmWinMngmt*
polyxmass_winmngmt_register_window (gchar *module,
				    GtkWidget *wnd,
				    GtkWidget *parent_wnd,
				    PxmEditCtxt *editctxt,
				    gchar *desc,
				    gchar *comment,
				    gboolean can_report,
				    gchar* (*make_report) ());

gint
polyxmass_winmngmt_un_register_window (GtkWidget *wnd, gchar *module);







/* FREE'ING FUNCTIONS
 */
gint
polyxmass_winmngmt_free (PxmWinMngmt* winmngmt);



/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxmass_winmngmt_GPA_free (GPtrArray *GPA);

gint
polyxmass_winmngmt_GPA_of_GPA_free (GPtrArray *GPA);





#endif /* POLYXMASS_WINDOW_MGMT_H */
