/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_USERSPEC_H
#define LIBPOLYXMASS_USERSPEC_H


#include "libpolyxmass-globals.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



  typedef struct _PxmUserSpec PxmUserSpec;
  typedef enum _PxmUserSpecDup PxmUserSpecDup;

  struct _PxmUserSpec
  {
    gchar *username;
    gchar *configdir;
    gchar *gladedir;
    gchar *workdir;
    gchar *datadir;

    /* The traditional array of prop objects.
     */
    GPtrArray *propGPA;
  };
  
  enum _PxmUserSpecDup
    {
      PXM_USERSPEC_DUP_DEEP_NO = 0,
      PXM_USERSPEC_DUP_DEEP_YES,
    };
  

  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */

  PxmUserSpec *
  libpolyxmass_userspec_new (void);

  PxmUserSpec *
  libpolyxmass_userspec_dup (PxmUserSpec *userspec, gint how_dup);

  gboolean
  libpolyxmass_userspec_set_username (PxmUserSpec *userspec, gchar *username);

  gchar *
  libpolyxmass_userspec_get_username (PxmUserSpec *userspec);

  gboolean
  libpolyxmass_userspec_set_configdir (PxmUserSpec *userspec, gchar *dir);

  gchar *
  libpolyxmass_userspec_get_configdir (PxmUserSpec *userspec);

  gboolean
  libpolyxmass_userspec_set_gladedir (PxmUserSpec *userspec, gchar *dir);

  gchar *
  libpolyxmass_userspec_get_gladedir (PxmUserSpec *userspec);

  gboolean
  libpolyxmass_userspec_set_workdir (PxmUserSpec *userspec, gchar *dir);

  gchar *
  libpolyxmass_userspec_get_workdir (PxmUserSpec *userspec);

  gboolean
  libpolyxmass_userspec_set_datadir (PxmUserSpec *userspec, gchar *dir);

  gchar *
  libpolyxmass_userspec_get_datadir (PxmUserSpec *userspec);



  /* UTILITY FUNCTIONS
   */






  /* FREE'ING FUNCTIONS
   */
  gboolean
  libpolyxmass_userspec_free (PxmUserSpec *userspec);










#ifdef __cplusplus
}
#endif /* __cplusplus */





#endif





