/*
** pork_screen_cmd.h - screen management.
** Copyright (C) 2002-2003 Ryan McCabe <ryan@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
*/

#ifndef __PORK_SCREEN_CMD_H
#define __PORK_SCREEN_CMD_H

struct imwindow;
struct pork_acct;

void screen_win_msg(struct imwindow *win,
					int ts,
					int banner,
					int color,
					char *fmt, ...) __format((printf, 5, 6));

inline void screen_write(struct imwindow *win, char *buf);
inline void screen_nocolor_msg(char *fmt, ...) __format((printf, 1, 2));
inline void screen_status_msg(char *fmt, ...) __format((printf, 1, 2));
inline void screen_status_msg_ts(char *fmt, ...) __format((printf, 1, 2));
inline void screen_err_msg(char *fmt, ...) __format((printf, 1, 2));
inline void screen_output(char *fmt, ...) __format((printf, 1, 2));

void screen_win_target_msg(	struct pork_acct *acct,
							char *target,
							int timestamp,
							char *fmt, ...) __format((printf, 4, 5));

int screen_draw_input(void);
void screen_window_swap(dlist_t *new_cur);
int screen_goto_window(u_int32_t refnum);
void screen_refresh(void);
struct imwindow *screen_new_window(struct pork_acct *o, char *dest, char *name);
struct imwindow *screen_new_chat_window(struct pork_acct *acct, char *name);

int screen_close_window(struct imwindow *imwindow);
void screen_cycle_fwd(void);
void screen_cycle_bak(void);
void screen_draw_cursor(void);
void screen_doupdate(void);
int screen_set_quiet(int status);
inline void screen_set_dirty(void);
int screen_get_passwd(char *buf, size_t len);

void screen_print_multiline(struct imwindow *win, char *msg, int timestamp);

#endif
