#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mysql/mysql.h>
#include "gld.h"

MYSQL *sql;

int SQLConnect(char *host,char *user,char *passwd,char *db)
{

MYSQL *sqlh;

sqlh=mysql_init(NULL);
if(sqlh==(MYSQL *)NULL) return(-1);

sql=mysql_real_connect(sqlh,host,user,passwd,db,0,NULL,0);
if(sql==(MYSQL *)NULL) return(-2);

return(0);
}

void SQLClose(void)
{
if(sql!=(MYSQL *)NULL) mysql_close(sql);
}

long SQLQuery(char *q)
{
int r;
MYSQL_RES *result;
MYSQL_ROW row;
int n;

if(sql!=(MYSQL *)NULL) r=mysql_query(sql,q); else r=-1;
if(r!=0) return(-1);

result=mysql_store_result(sql);
if(result==(MYSQL_RES *)NULL) return(0);

n=mysql_num_rows(result);
if(n==0) return(0);

row=mysql_fetch_row(result);
mysql_free_result(result) ;
return(atol(row[0]));
}

void ShowBaseInfo(void)
{
char query[QLEN];
int c;
long now;

now=time(0);

sprintf(query,"select count(*) from greylist");
c=SQLQuery(query);
printf("# of entries in the database         : %d\n",c);

if(c!=0)
	{
	sprintf(query,"select count(*) from greylist where n=1");
	c=SQLQuery(query);
	printf("# of one hit entries in the database : %d\n",c);

	sprintf(query,"select min(first) from greylist");
	c=SQLQuery(query);
	printf("Oldest entry in database             : %ld days ago\n",(now-c)/86400);
	}
}

void Quote(char *str)
{
int i,l;

l=strlen(str);
for(i=0;i<l;i++)
	if(str[i]=='"' || str[i]=='\'' || str[i]==';') str[i]=' ';

}
