/*
 Copyright (C) 2010 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

public class Postler.CellRendererToggle : Gtk.CellRendererToggle {
    public string? stock_id { get; set; }
    public string? prelight_stock_id { get; set; }

    public CellRendererToggle () {
    }
    public override void get_size (Gtk.Widget widget, Gdk.Rectangle? cell_area,
        out int x_offset, out int y_offset, out int width, out int height) {
        if (&x_offset != null) x_offset = 0;
        if (&y_offset != null)
            y_offset = cell_area != null ? cell_area.height / 3 : 0;
        if (&width != null && &height != null)
            Gtk.icon_size_lookup_for_settings (widget.get_settings (),
                Gtk.IconSize.MENU, out width, out height);
    }
    public override void render (Gdk.Window window, Gtk.Widget widget,
        Gdk.Rectangle background_area, Gdk.Rectangle cell_area,
        Gdk.Rectangle expose_area, Gtk.CellRendererState flags) {

        var context = Gdk.cairo_create (window);
        Gdk.cairo_rectangle (context, expose_area);
        Gdk.cairo_rectangle (context, background_area);

        int x, y;
        Gdk.Pixbuf? icon = null;

        window.get_pointer (out x, out y, null);
        /* if (expose_area.intersect (cell_area, null) */
        if (Gdk.rectangle_intersect (expose_area, cell_area, null)
         && (flags & Gtk.CellRendererState.PRELIT) != 0
         && prelight_stock_id != null) {
            icon = widget.render_icon (prelight_stock_id, Gtk.IconSize.MENU, null);
        }
        else if (stock_id != null) {
            icon = widget.render_icon (stock_id, Gtk.IconSize.MENU, null);
        }
        if (icon != null) {
            Gdk.cairo_set_source_pixbuf (context, icon,
                cell_area.x, cell_area.y + cell_area.height / 3);
            context.fill ();
        }
    }
}

