/*                               
XVector.h
*/

#ifndef __XVECTOR_H
#define __XVECTOR_H

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

typedef int UINT;

template <class Etype>
class XVector
{
public:
        XVector( UINT initialCapacity = 10, UINT capacityIncrement = 10 );
        XVector( const XVector& rhv );
        virtual ~XVector();

        //Inspectors (additional exception throwing inspectors below)
        //===========================================================
        UINT capacity() const;
        int contains( const Etype &elem ) const;
        const Etype & firstElement() const;
        int indexOf( const Etype &elem ) const;
        int isEmpty() const;
        const Etype & lastElement() const;
        int lastIndexOf( const Etype &elem ) const;
        UINT size() const;
        UINT Count() const;
        void copyInto( Etype* array ) const;

        //Modifiers (additional exception throwing inspectors below)
        //==========================================================
        void addElement( const Etype &obj );
        void Add ( const Etype &obj );  //ALIAS AL ANTERIOR
        void ensureCapacity( UINT minCapacity );
        void removeAllElements();
        void Clear();  //ALIAS AL ANTERIOR
        int removeElement( const Etype &obj );
        void setSize( UINT newSize );
        void trimToSize();

        //Exceptions are thrown at run time with the following functions if
        //the index parameter is not within a valid range.  If the data
        //is uncertain (i.e. user inputed), then you should wrap these function
        //calls with the try/catch blocks and handle them appropriately.
        //===============================================
        Etype & elementAt( UINT index ) const;            //inspector
        Etype & getString( UINT index ) const;   //ALIAS AL ANTERIOR
        Etype & getStr( UINT index );         //COMO EL ANTERIOR PERO NO DEVUELVE CONSTANTE CHAR
        void insertElementAt( const Etype &obj, UINT index ); //modifier
        void removeElementAt( UINT index );                                //modifier
        void setElementAt( const Etype &obj, UINT index );      //modifier

        void SORT (int (*compare)(const void *, const void *), void (*flip)(const void *, const void *));
        void SORTNew (int (*compare)(const void *, const void *), void (*flip)(const void *, const void *));                              

        //C++ specific operations
        //=======================
        Etype & operator[]( UINT index );

        int SaveToFile (const char *fname, bool PutCR);
        int LoadFromFile (const char *fname);
        char *toPChar (bool PutCR);

protected:
        int min( UINT left, UINT right ) const;
        void verifyIndex( UINT index, char *debug ) const;
        void ajustIndex( UINT &index) const;
        UINT m_size;
        UINT m_capacity;
        UINT m_increment;
        Etype** m_pData;
};

//===============================================================
//Implementation of constructor, destructor, and member functions
//Necessary location for appropriate template enstantiation.
//===============================================================
template <class Etype>
XVector<Etype>::XVector( UINT initialCapacity, UINT capacityIncrement ) 
{
        m_size = 0;
        m_capacity = initialCapacity;
        m_pData = new Etype*[ m_capacity ];
        m_increment = capacityIncrement;
}

template <class Etype>
XVector<Etype>::XVector( const XVector<Etype>& rhv )
{
        m_size = rhv.m_size;
        m_capacity = rhv.m_capacity;
        m_pData = new Etype*[ m_capacity ];
        m_increment = rhv.m_increment;

        for( UINT i = 0; i < m_size; i++ )
        {
                m_pData[i] = new Etype( *(rhv.m_pData[i]) );
        }
}

template <class Etype>
XVector<Etype>::~XVector()
{
        removeAllElements();
        delete [] m_pData;
}

template <class Etype>
UINT
XVector<Etype>::capacity() const
{
        return m_capacity;
}

template <class Etype>
int
XVector<Etype>::contains( const Etype &elem ) const
{
        for ( UINT i = 0; i < m_size; i++ )
        {
                if ( *m_pData[i] == elem )
                        return 1;
        }

        return 0;
}

template <class Etype>
void
XVector<Etype>::copyInto( Etype* array ) const
{
        for( UINT i = 0; i < m_size; i++ )
                array[i] = *m_pData[i];
}


template <class Etype>
Etype &
XVector<Etype>::elementAt( UINT index ) const
{
        //verifyIndex( index, "elementAt" );
        ajustIndex (index);
        return *m_pData[index];
}

template <class Etype>
Etype &
XVector<Etype>::getString( UINT index ) const
{
        //verifyIndex( index, "getString" );
        ajustIndex (index);
        return *m_pData[index];
}

template <class Etype>
Etype &
XVector<Etype>::getStr( UINT index )
{
        verifyIndex( index, "getStr" );
        return *m_pData[index];
}

template <class Etype>
const Etype &
XVector<Etype>::firstElement() const
{
        if ( m_size == 0 )
        {
                //throw "Empty XVector Exception";
                printf ("firstElement() called on empty XVector\n");
                exit(1);
        }

        return *m_pData[ 0 ];
}

template <class Etype>
int
XVector<Etype>::indexOf( const Etype &elem ) const
{
        for ( UINT i = 0; i < m_size; i++ )
        {
                if ( *m_pData[ i ] == elem )
                        return i;
        }

        return -1;
}

template <class Etype>
int
XVector<Etype>::isEmpty() const
{
        return m_size == 0;
}

template <class Etype>
const Etype &
XVector<Etype>::lastElement() const
{
        if ( m_size == 0 )
        {
                //throw "Empty XVector Exception"
                printf("lastElement() called on empty XVector\n");
                exit(1);
        }

        return *m_pData[ m_size - 1 ];
}

template <class Etype>
int
XVector<Etype>::lastIndexOf( const Etype &elem ) const
{
        //check for empty vector
        if ( m_size == 0 )
                return -1;

        UINT i = m_size;
        
        do
        {
                i -= 1;
                if ( *m_pData[i] == elem )
                        return i;

        }
        while ( i != 0 );

        return -1;
}

template <class Etype>
UINT
XVector<Etype>::size() const
{
        return m_size;
}

template <class Etype>
UINT
XVector<Etype>::Count() const
{
        return m_size;
}

template <class Etype>
void
XVector<Etype>::addElement( const Etype &obj )
{
        if ( m_size == m_capacity )
                ensureCapacity( m_capacity + m_increment );

        m_pData[ m_size++ ] = new Etype( obj );
}

template <class Etype>
void
XVector<Etype>::Add( const Etype &obj )
{
        if ( m_size == m_capacity )
                ensureCapacity( m_capacity + m_increment );

        m_pData[ m_size++ ] = new Etype( obj );
}

template <class Etype>
void
XVector<Etype>::ensureCapacity( UINT minCapacity )
{
        if ( minCapacity > m_capacity )
        {
                UINT i;
                m_capacity = minCapacity;

                Etype** temp = new Etype*[ m_capacity ];

                //copy all the elements over upto newsize
                for ( i = 0; i < m_size; i++ )
                        temp[i] = m_pData[i];

                delete [] m_pData;
                m_pData = temp;
        }
}

template <class Etype>
void
XVector<Etype>::insertElementAt( const Etype &obj, UINT index )
{
        if ( index > m_size )
                verifyIndex( index, "insertElementAt" );   //this will throw if true

        if ( m_size == m_capacity )
                ensureCapacity( m_capacity + m_increment);

        Etype* newItem = new Etype(obj);        //pointer to new item
        Etype* tmp;                                                     //temp to hold item to be moved over.
        for( UINT i = index; i < m_size; i++ )
        {
                tmp = m_pData[i];
                m_pData[i] = newItem;

                if ( i + 1 != m_size )
                        newItem = tmp;
                else
                {
                        m_pData[i+1] = tmp;
                        break;
                }
        }

        m_size++;
}

template <class Etype>
void
XVector<Etype>::removeAllElements()
  {
  //avoid memory leak
  for (UINT i = 0; i < m_size; i++ ) {delete m_pData[i];}
  m_size = 0;
  }

template <class Etype>
void
XVector<Etype>::Clear()
{
        //avoid memory leak
        for ( UINT i = 0; i < m_size; i++ )
                delete m_pData[i];

        m_size = 0;
}

template <class Etype>
int
XVector<Etype>::removeElement( const Etype &obj )
{
        for ( UINT i = 0; i < m_size; i++ )
        {
                if ( *m_pData[i] == obj )
                {
                        removeElementAt( i );
                        return 1;
                }
        }

        return 0;
}

template <class Etype>
void
XVector<Etype>::removeElementAt( UINT index )
{
        verifyIndex( index, "removeElementAt" );

        delete m_pData[ index ];

        for ( UINT i = index+1; i < m_size; i++ )
                m_pData[ i - 1 ] = m_pData[ i ];

        m_size--;
}

template <class Etype>
void
XVector<Etype>::setElementAt( const Etype &obj, UINT index )
{
        verifyIndex( index, "setElementAt" );

        *m_pData[ index ] = obj;
}

template <class Etype>
void
XVector<Etype>::setSize( UINT newSize )
{
        if ( newSize > m_capacity )
                ensureCapacity( newSize );
        else if ( newSize < m_size )
        {
                for( UINT i = newSize; i < m_size; i++ )
                        delete m_pData[i];

                m_size = newSize;
        }
}

template <class Etype>
void
XVector<Etype>::trimToSize()
{
        if ( m_size != m_capacity )
        {
                Etype** temp = new Etype*[ m_size ];
                UINT i;

                for ( i = 0; i < m_size; i++ )
                        temp[i] = m_pData[i];

                delete [] m_pData;

                m_pData = temp;
                m_capacity = m_size;
        }
}

template <class Etype>
int
XVector<Etype>::min( UINT left, UINT right ) const
{
        return left < right ? left : right;
}

template <class Etype>
void
XVector<Etype>::SORT (int (*compare)(const void *, const void *), void (*flip)(const void *, const void *))
  {
  int changed, res;
  do 
    {
    changed = 0;
    for (int i = 0; i < m_size - 1; ++i)
      {
      res = compare (m_pData[i + 1], m_pData[i]);
      if (res < 0)  
        {
        flip (m_pData[i], m_pData[i + 1]);
        changed = 1;
        }
      }
    } 
  while (changed);
  }

template <class Etype>
void
XVector<Etype>::verifyIndex( UINT index, char *debug ) const
{
        if ( index >= m_size )
        {
                //throw "Index Out Of Bounds";
                fprintf (stderr, "XVector.h: Index Out Of Bounds. Function='%s'. Total=%d, index=%d\n", debug, m_size, index);
                exit(1);
        }
}

template <class Etype>
void
XVector<Etype>::ajustIndex( UINT &index) const
{
        if ( index >= m_size ) {index = m_size - 1;}
        if ( index < 0 ) {index = 0;}
}       

template <class Etype>
Etype &
XVector<Etype>::operator[]( UINT index )
{
        verifyIndex( index, "operator[]" );
        return *m_pData[ index ];
}

template <class Etype>
int
XVector<Etype>::SaveToFile (const char *fname, bool PutCR)
        
{
        int res, lockres, fdFW; 
        FILE *FW;
        FW = fopen (fname, "w");
        if (FW == NULL) {return -1;}
        fdFW = fileno (FW);
        lockres = lockf (fdFW, F_LOCK, 0);
        if (lockres != 0) {fclose (FW); return -1;}
        for ( UINT i = 0; i < m_size; i++ )
          {
          if (PutCR == true)
            {
            res = fprintf (FW, "%s\n", (char *) (*m_pData[i]).cstr());
            }
          else
            {
            res = fprintf (FW, "%s", (char *) (*m_pData[i]).cstr());
            }          
          if (res <= 0) {lockf (fdFW, F_ULOCK, 0); fclose (FW); return -1;}
          }      
        lockres = lockf (fdFW, F_ULOCK, 0);
        if (fclose (FW) != 0) {return -1;}
        return 0;
}

template <class Etype>
int
XVector<Etype>::LoadFromFile (const char *fname)
        
{
        char abuf[2001];
        FILE *FR;
        Clear();
        FR = fopen (fname, "r");
        if (FR == NULL) {return -1;}
        
        while (fscanf (FR, "%2000s\n", abuf) != EOF)
          {
          Add (abuf);
          }
                               
        if (fclose (FR) != 0) {return -1;}
        return 0;
}

template <class Etype>
char *
XVector<Etype>::toPChar (bool PutCR)
{
   XString xs;
   xs = XString("");
   for ( UINT i = 0; i < m_size; i++ )
     {
     if (PutCR == true)
       {
       xs += (*m_pData[i]).cstr();
       xs += "\n";
       }
     else
       {
       xs += (*m_pData[i]).cstr();
       }
     }
   return xstrdup(xs.cstr());                  
}

#endif



