/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef PLAYER_H
#define PLAYER_H

typedef struct {
	int seekable;
	double pos;
	double len;
	sample_format in_fmt;
	sample_format out_fmt;
	float bitrate;
	int converting;
	int processing;
	char *error;
	gboolean error_stop;
} player_status;
void status_set_error(player_status *status, const char *error, gboolean stop);

void player_init(int *argc, char ***argv, player_status *status);
gboolean player_start(const gchar *path);
void player_stop(void);
void player_release(void);
void player_pause(void);
void player_unpause(void);
void player_seek(gdouble pos);

#endif

