/*
 * Potamus: an audio player
 * Copyright (C) 2004, 2005, 2006, 2007 Adam Sampson <ats@offog.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef PROCESS_H
#define PROCESS_H

enum process_type {
	PROCESS_NONE = 0,
	PROCESS_MONO,
	PROCESS_OOPS,
	PROCESS_PHASE,
	PROCESS_LEFT,
	PROCESS_RIGHT,
	PROCESS_SWAP,
};

#ifdef WANT_PROCESS_LABELS
// Kept here so that they can easily match the process_type enum.
static const char *process_labels[] = {
	"None",
	"Mono",
	"OOPS",
	"Phase",
	"Left",
	"Right",
	"Swap",
	NULL
};
#endif

void process_audio(float *channels, int num_channels, int processing);

#endif
