//******************************************************************************
// Copyright (C) 1998-2003 TLK Games all rights reserved.
//------------------------------------------------------------------------------
// file         : "main.cpp"
// created      : 1999-08-17
// updates      : 2003-07-01
//------------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
// details.
//  
// You should have received a copy of the GNU General Public License along with
// this program; if not, write to the Free Software Foundation, Inc., 59 Temple
// Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************
#include "powermanga.hpp"
//..............................................................................
extern const char      *nomfichierscore[]= { SCOREFILE "-easy", SCOREFILE, SCOREFILE "-hard" };
extern const char       nomprefix[]=PREFIX;
extern unsigned int     iCompteurBoucle;
extern int              vmode;                                 // 0=320*200 ; 1=640*400 
extern int              fullscreen;                            // 1=full screen (use dga)
#ifdef UTILISE_SEAL
extern unsigned int     utilise_seal;                          // 1=use SEAL for music and sound
#endif
//..............................................................................
int                     gameLevel=1;                           // Game difficulty (Laurent Duperval)
unsigned int            iVerbeux = 0;                          // 1=verbose mode, 2=super verbose mode
int                     quit_game = 0;                         // 1=leave the game
int                     nosync = 0;                            // 1=pas d'attente avant deux images du jeu / no sleep between two images
unsigned int            iFrame = 14286;                        // game speed : 70 frames/sec
unsigned int            iFrame2 = 20000;                       // music speed : 50 frames/sec
unsigned int            iFrame3 = 35715;                       // game speed : 28 frames/sec
extern unsigned int     iJoueIntro;                            // (1=animation du debut/start anim ; 2=animation de fin/end anim )

//..............................................................................

void                    scan_arguments(int _iNombreArgument, char **_pArguments);
int                     powermanga();

//------------------------------------------------------------------------------
// main : a very simple main function  
// input => _iNombreArgument : taille de la chaine d'argument / size of string
//       => _pArguments      : pointeur sur le pointeur contenat la dite chaine
//                             pointer to the pointer to the arguments
//------------------------------------------------------------------------------
int main(int _iNombreArgument, char **_pArguments)
{ 
  scan_arguments(_iNombreArgument, _pArguments);
  powermanga();
  exit(0);
}

//------------------------------------------------------------------------------
// thread 1 : powermanga
//------------------------------------------------------------------------------
int powermanga()
{ 
  int _iTempsPause = 0;
  int _iTempsDifference = 0;
#ifdef UTILISE_SEAL
  seal_init();
  seal_JoueModule(0);
#endif
  fps_init();
  if(!mem_initialise(22000))
    exit(1);                                                   //allocate memory table
  if(xw_init() == 1)                                           //xwindow initialize
  { if(!inits_game())
      goto quitter;
    else
    {
#ifdef _VERBEUX_
      if(iVerbeux > 0) afficheMessage("powermanga() / Welcome in PowerManga. The program is running !\n\n");
#endif
      type_routine_gfx();
      do
      { iCompteurBoucle++;                                     //counter of loops
        if(nosync == 0)
        { _iTempsDifference = synchro_CalculDifference();
          if(iJoueIntro)
            _iTempsPause = synchro_processusPause(iFrame3 - _iTempsDifference + _iTempsPause);
          else
            _iTempsPause = synchro_processusPause(iFrame - _iTempsDifference + _iTempsPause);
        }
        if(!UpdateFrame())
          quit_game = 1;                                       //"powermanga.cpp" : update all
        xw_exec();                                            //display window or screen
#ifdef UTILISE_SEAL
        seal_exec();
#endif
      }
      while (quit_game == 0);
#ifdef _VERBEUX_
        if(iVerbeux > 0) afficheMessage("powermanga() : OK, OK, you want to leave !\n");
#endif
    }
  }
quitter:;
  xw_kill();                                                   //free xwindow ressources
  fps_affiche();
  mem_libereTous();                                            //free all memory
#ifdef _VERBEUX_
  if(iVerbeux > 0)
    afficheMessage("PowerManga : end program ! bye bye\n\n");
#endif
  return 0;
}



//------------------------------------------------------------------------------
// scan_arguments       : analyse les arguements 
// _iNombreArgument     : taille de la chaine d'argument
// _pArguments          : pointeur sur le pointeur contenat la dite chaine
//------------------------------------------------------------------------------
void scan_arguments(int _iNombreArgument, char **_pArguments)
{
  int                     _iIndex;
#ifdef UTILISE_SEAL
  utilise_seal = 1;
#endif
  for(_iIndex = 1; _iIndex < _iNombreArgument; _iIndex++)
  {
    if(*_pArguments[_iIndex] == '-')
    {
      if(strcmp(_pArguments[_iIndex], "-h") == 0
         || strcmp(_pArguments[_iIndex], "--help") == 0)
      {
        printf("\noptions:\n");
        printf("-h, --help     print Help (this message) and exit\n");
        printf("--version      print version information and exit\n");
        //printf("--640          game run in a 640*400 window\n");
        printf("--320          game run in a 320*200 window (slow machine)\n");
        printf("--full         game run in direct to screen with DGA (very experimental)\n");
        printf("-v             verbose mode\n");
        printf("--verbose      verbose mode (more messages)\n");
        printf("--nosound      force no sound\n");
        printf("--nosync       disable timer\n");
        printf("--easy         easy bonuses\n");               // (Laurent Duperval)
        printf("--hard         hard bonuses\n");               // (Laurent Duperval)
        printf("--------------------------------------------------------------\n");
        printf("keys recognized during the game:\n");
        printf("CTRL+S         enable/disable the music\n");
        printf("CTRL+Q         finish the play current\n");
        printf("CTRL+A         about Powermanga\n");
        printf("F10            quit Powermanga\n");
        printf("P              enable/disable pause\n");
        printf("\n");
        if(!iVerbeux && vmode && !fullscreen)
          exit(0);
      }
      else
      {
        if(strcmp(_pArguments[_iIndex], "--version") == 0)
        {
          printf(POWERMANGA_VERSION);
          printf("\n");
          printf("copyright (c) 2003 TLK Games\n");
          printf("website : http://linux.tlk.fr\n");
          if(!iVerbeux && vmode && !fullscreen)
            exit(0);
        }
        else
        { if(strcmp(_pArguments[_iIndex], "--easy")==0)        // (Laurent Duperval)
          { gameLevel = 0;
          }
          else
          { if(strcmp(_pArguments[_iIndex], "--hard")==0)      // (Laurent Duperval)
            { gameLevel = 2;
            }
            else
            { if(strcmp(_pArguments[_iIndex], "--verbose") == 0)
              { iVerbeux = 2;
              }
              else
              {
                if(strcmp(_pArguments[_iIndex], "-v") == 0)
                { iVerbeux = 1;
                }
                else
                { if(strcmp(_pArguments[_iIndex], "--320") == 0)
                  { vmode = 0;
                  }
                  else
                  { if(strcmp(_pArguments[_iIndex], "--full") == 0)
                    { fullscreen = 1;
                    }
                    else
                    { if(strcmp(_pArguments[_iIndex], "--nosync") == 0)
                      { nosync = 1;
                      }
                      else if(strcmp(_pArguments[_iIndex], "--nosound") == 0)
                      {
#ifdef UTILISE_SEAL
                        utilise_seal = 0;
#endif
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }                                                          //=='-'
  }                                                            //for
}

