#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/types.h>

#include <config.h>
#include <support.h>
#include <xcio.h>

struct pppinfo_s pppInfo;

int
XcioWrite(int fd, struct xcio_s *xcp)
{
    return(write(fd, xcp, sizeof(xcp->xid) + sizeof(xcp->len)
		 + sizeof(xcp->type) + xcp->len));
}

/*
 * New scheme
 */

static struct xciobuf_s {
    struct xciobuf_s *next;
    struct xcio_s xc;
    int fd, got;
    enum {XCIN_TYPE=0, XCIN_XID, XCIN_LEN, XCIN_DATA} st;
} *xbHead;

void
XcioOpen(int fd)
{
    struct xciobuf_s *xbp;

#if 0
    int fdf;
    if ((fdf = fcntl(fd, F_GETFL)) >= 0)
	fcntl(fd, F_SETFL, fdf | O_NONBLOCK);
#endif
    xbp = TALLOC(struct xciobuf_s);
    memset(xbp, 0, sizeof(*xbp));
    xbp->fd = fd;
    xbp->next = xbHead;
    xbHead = xbp;
}

void
XcioClose(int fd)
{
    struct xciobuf_s *xbp=xbHead, *xbp0;

    xbp0 = NULL;
    while (xbp) {
	if (xbp->fd == fd) {
	    if (xbp0) xbp0->next = xbp->next;
	    else xbHead = xbp->next;
	    Free(xbp);
	    break;
	}
	xbp0 = xbp;
	xbp = xbp->next;
    }
}

int
XcioRead(int fd, struct xcio_s *xc)
{
    struct xciobuf_s *xbp=xbHead;
    int n, ret=-1;
    u_char ch;

    while (xbp) {
	if (xbp->fd == fd) break;
	xbp = xbp->next;
    }
    if (!xbp) return(-1);
    while ((n = read(fd, &ch, 1)) > 0) {
	ret = 0;
	switch (xbp->st) {
	case XCIN_LEN:
	    xbp->xc.len = ch;
	    xbp->st = XCIN_DATA;
	    if (ch) break;
	case XCIN_DATA:
	    xbp->xc.buf[xbp->got] = ch;
	    xbp->got ++;
	    if (xbp->got >= xbp->xc.len) {
		memcpy(xc, &xbp->xc, xbp->xc.len + sizeof(xbp->xc.xid)
		       + sizeof(xbp->xc.len) + sizeof(xbp->xc.type));
		xbp->st = XCIN_TYPE;
		return(xc->type);
	    }
	    break;
	case XCIN_XID:
	    xbp->xc.xid = ch;
	    xbp->st = XCIN_LEN;
	    break;
	case XCIN_TYPE:
	default:
	    xbp->xc.type = ch;
	    xbp->got = 0;
	    xbp->st = XCIN_XID;
	    break;
	}
    }
    return(ret);
}
