#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <sys/param.h>

#include <config.h>
#include <support.h>
#include <account.h>

#include "option.h"
#include "frame.h"
#include "auth.h"
#include "console.h"
#include "command.h"
#include "log.h"
#include "env.h"

/*#include <tcio.h>*/

struct pppopt_s pppOpt;

static const char *loadFilePath="conf";

const char *
SetLoadFilePath(const char *new)
{
    const char *old;

    old = loadFilePath;
    loadFilePath = new;
    return(old);
}

FILE *
OpenFile(char *name, const char *dir, int *secure)
{
    FILE *fp=NULL;
    struct stat st;
    int len1, len2;
    char tmp[MAXPATHLEN];

    memset(tmp, 0, sizeof(tmp));
    if (*name == '!') {
	*secure |= EXEC_POPEN;
	name ++;
    } else if (*name == '/') {
	*secure |= EXEC_SECURE;
	name ++;
    }
    len1 = strlen(sysPPxP);
    len2 = usrPPxP ? strlen(usrPPxP): 0;
    if (len1 < len2) len1 = len2;
    len1 += strlen(name) + (dir ? strlen(dir): 0);
    if (len1 > sizeof(tmp) - 1) errno = ENAMETOOLONG;
    else {
	if (!(*secure & EXEC_SECURE) && usrPPxP) {
	    if (dir) sprintf(tmp, "%s/%s/%s", usrPPxP, dir, name);
	    else sprintf(tmp, "%s/%s", usrPPxP, name);
	    if (*secure & EXEC_POPEN) {
		if (!access(tmp, X_OK)) fp = popen(tmp, "r");
	    } else fp = fopen(tmp, "r");
	    *secure &= ~EXEC_SECURE;
	}
	if (fp == NULL) {
	    if (dir) sprintf(tmp, "%s/%s/%s", sysPPxP, dir, name);
	    else sprintf(tmp, "%s/%s", sysPPxP, name);
	    SuperPrivilege(TRUE);
	    if (*secure & EXEC_POPEN) {
		if (!access(tmp, X_OK)) fp = popen(tmp, "r");
	    } else fp = fopen(tmp, "r");
	    if (fp != NULL) *secure |= EXEC_SECURE;
	    SuperPrivilege(FALSE);
	}
    }
    if (!fp) LogError(tmp[0] ? tmp: name);
    else if (ISLOG(LOG_OS))
	Logf(LOG_OS, "%copen(%s) OK\n",
	     (*secure & EXEC_POPEN) ? 'p': 'f', tmp);
    return(fp);
}

int
LoadFile(FILE *fp, int (*proc)(), int secure, void *arg)
{
    char *p, *buf, *endp;
    int retval=0;
    char line[BUFSIZ];

    buf = line;
    endp = line + sizeof(line) - 1;
    while (!retval && fgets(buf, endp - buf, fp)) {
	p = buf + strlen(buf) - 1;
	while ((p > buf) && strchr("\r\n \t", *p)) p --;
	if (p <= buf) continue;
	if (*p == '\\') {
	    *p = ' ';
	    buf = p + 1;
	    continue;
	}
	p = line;
	while (*p && strchr("\t ", *p)) p ++;
	if (p && *p && *p != '#') retval = proc(p, secure, arg);
	buf = line;
    }
    if (secure & EXEC_POPEN) pclose(fp);
    else fclose(fp);
    return(retval);
}

static int
ConfFileProc(char *line, int secure)
{
    RunCommandLine(line, secure ? EXEC_SECURE: 0);
    return(0);
}

int
LoadScriptFile(char *name)
{
    int secure=0;
    FILE *fp;

    fp = OpenFile(name, loadFilePath, &secure);
    return(fp ? LoadFile(fp, ConfFileProc, secure, NULL): -1);
}

int
LoadOption(int argc, char *argv[])
{
    int a;
    char *ev[]={"set", "NAME", ""};
    bool_t copy=FALSE;

    for (a = 1; a < argc; a ++) {
	if (!pppOpt.name) {
	    ev[2] = argv[a];
	    EnvSet(3, ev);
	    copy = TRUE;
	}
	if (LoadScriptFile(argv[a]) < 0 && copy) {
	    Free(pppOpt.name);
	    pppOpt.name = NULL;
	}
	copy = FALSE;
    }
    if (!pppOpt.a_entry) {
	ev[1] = "AUTH.PASSWD";
	ev[2] = pppOpt.name;
	EnvSet(3, ev);
    }
    return(0);
}

int
SaveOption(int argc, char *argv[])
{
    FILE *fp;
    char *name, *top;
    struct stat st;
    int len;

    if (argc < 2) return(-1);
    top = getuid() ? usrPPxP: sysPPxP;
    len = strlen(top) + strlen(argv[1]) + 8;
    name = Malloc(len);
    sprintf(name, "%s/conf/%s", top, argv[1]);
    if ((fp = fopen(name, "w")) == NULL) {
	LogError(name);
	Free(name);
	return(-1);
    }
    AllEnvPrint(fp, ENV_RDONLY);
    fclose(fp);
    chown(name, getuid(), getgid());
    Free(name);
    return(0);
}

int
AccountLogWrite(bool_t start)
{
    struct accrec_s acc;
    int fd;
    static u_int32_t accId;

    if (!start && !accId) return(-1);
    memset(&acc, 0, sizeof(acc));
    SuperPrivilege(TRUE);
    fd = open(_PATH_PPXP_ACC, O_APPEND|O_WRONLY|O_CREAT, 0644);
    SuperPrivilege(FALSE);
    if (fd < 0) {
	LogError(_PATH_PPXP_ACC);
	return(-1);
    }
    if (start) {
	struct stat st;

	fstat(fd, &st);
	acc.uid = geteuid();
	acc.pid = getpid();
	accId = (u_int32_t)(st.st_size / sizeof(struct accrec_s)) + 1;
	acc.aid = accId;
    } else {
	acc.aid = accId;
	accId = 0;
    }
    strncpy(acc.name, pppOpt.name ? pppOpt.name: "?", LEN_ACC_NAME);
    time(&(acc.time.sec));
    write(fd, (char *)&acc, sizeof(acc));
    close(fd);
    return(0);
}

int
LastLogWrite(bool_t start)
{
    static char *lastLine;
    int ret;
    char *user, *host;

    user = host = NULL;
    if (start) {
	char *p;

	p = AuthName();
	if (!p) return(0);
	user = Strdup(p);
	if (pppOpt.line) {
	    if ((p = strrchr(*pppOpt.line, '/')) != NULL) p ++;
	    else p = *pppOpt.line;
	} else p = "redirect"; /* ;-< */
	if (lastLine) Free(lastLine);
	lastLine = Strdup(p);
	if (pppOpt.name) host = Strdup(pppOpt.name);
    } else if (!lastLine) return(0);
    SuperPrivilege(TRUE);
    ret = SysWtmp(lastLine, user, host);
    SuperPrivilege(FALSE);
    if (host) Free(host);
    if (user) Free(user);
    if (!start) {
	Free(lastLine);
	lastLine = NULL;
    }
    return(ret);
}
