/* KNN_threads.c
 *
 * Copyright (C) 2007-2008 Ola Söder
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * os 20090123 First version
 */

/////////////////////////////////////////////////////
//                                                 //
/////////////////////////////////////////////////////

#include <stdlib.h>
#include "KNN_threads.h"
#include "OlaP.h"

#if defined (__linux__)
    #define __USE_GNU
    #include <sched.h>

#elif defined (__MACOSX__) || defined (__FreeBSD__) || defined (__OpenBSD__) || defined (__NetBSD__)
    #include <sys/types.h>
    #include <sys/sysctl.h>
#endif

#include <pthread.h>

/////////////////////////////////////////////////////
//                                                 //
/////////////////////////////////////////////////////

int KNN_getNumberOfCPUs()
{
#if defined (__linux__)
    int ncpus = 0; 
    cpu_set_t * cpuset = (cpu_set_t *) malloc(sizeof(cpu_set_t));

    if(cpuset)
    {
        sched_getaffinity(0, sizeof(cpu_set_t), cpuset);
        for(int cpu = 0; cpu <= CPU_SETSIZE; ++cpu) 
            if(CPU_ISSET(cpu, cpuset))
                ++ncpus;
        free(cpuset);
    }

    ASSERT(ncpus >= 1);
    return(ncpus);
#elif defined (__MACOSX__) || defined (__FreeBSD__) || defined (__OpenBSD__) || defined (__NetBSD__)
    
    /* This code might or might not work.
     * Needs testing.

    int * ncpus;
    size_t len;
    int mib[2] = {CTL_HW, HW_NCPU};

    sysctl(mib, 2, ncpus, &len, NULL, 0);

    ASSERT(ncpus >= 1);
    return(ncpus);
    */
    return(1);
#else
    return(1);
#endif
}

void * KNN_threadDistribution(void * (* function) (void *), void ** input, int nthreads)
{
    ASSERT(function && input && nthreads > 0 && KNN_getNumberOfCPUs() > 1);
    if(!(function && input && nthreads > 0))
        return(NULL);

    pthread_t thread_ids[nthreads];

    for(int i = 0; i < nthreads; ++i)
        pthread_create(&thread_ids[i], NULL, function, input[i]);

    while(nthreads--)
        pthread_join(thread_ids[nthreads], NULL);

    return(NULL);
}

void KNN_threadTest()
{
    void * dummy[KNN_getNumberOfCPUs()];
    KNN_threadDistribution(KNN_threadTestAux, (void **) &dummy, KNN_getNumberOfCPUs());
}

void * KNN_threadTestAux(void * dummy)
{
    for(int i = 0; i < 50000; ++i)
        for(int i = 0; i < 50000; ++i);

    return(NULL);
}


