/* $Cambridge: hermes/src/prayer/cmd/cmd_roles_entry.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

static char *
mylookup(struct assoc *h, char *val)
{
    char *s = assoc_lookup(h, val);

    return((s) ? s : "");
}

static void generate_form(struct session *session, struct assoc *h)
{
    struct template_vals *tvals = session->template_vals;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;

    if (h) {
        template_vals_string(tvals, "alias", mylookup(h, "alias"));
        template_vals_string(tvals, "personal", mylookup(h, "personal"));
        template_vals_string(tvals, "from", mylookup(h, "from"));
        template_vals_string(tvals, "reply_to", mylookup(h, "reply_to"));
        template_vals_string(tvals, "fcc", mylookup(h, "fcc"));
        template_vals_string(tvals, "signature", mylookup(h, "signature"));
    }

    session_seed_template(session, tvals);
    template_expand("roles_entry", tvals, b);
    response_html(request, 200);        /* Success */
}

void cmd_roles_entry(struct session *session)
{
    struct config *config = session->config;
    struct request *request = session->request;
    struct options *options = session->options;
    struct assoc *h = NIL;
    char *alias;
    char *personal;
    char *from;
    char *reply_to;
    char *fcc;
    char *signature;

    if (request->method != POST) {
        if (request->get_suffix) {
            request_decode_form(request);
            h = request->form;
        }
        generate_form(session, h);
        return;
    }

    request_decode_form(request);
    h = request->form;

    if (assoc_lookup(h, "sub_cancel")) {
        session_redirect(session, request, "roles_list");
        return;
    }

    if ((alias = assoc_lookup(h, "alias")))
        alias = string_trim_whitespace(alias);

    if (assoc_lookup(h, "sub_delete")) {
        if (alias && alias[0]) {
            role_delete(options->role_list, alias);
            options->save = T;
            session_message(session, "Deleted role: \"%s\"", alias);
        } else
            session_message(session, "No role supplied to delete");

        session_redirect(session, request, "roles_list");
        return;
    }

    if (!assoc_lookup(h, "sub_update")) {
        session_message(session, "Invalid submit method for roles_entry");
        generate_form(session, h);
        return;
    }

    if ((personal = assoc_lookup(h, "personal")))
        personal = string_trim_whitespace(personal);

    if (config->fix_from_address) {
        from = "";
    } else {
        if ((from = assoc_lookup(h, "from")))
            from = string_trim_whitespace(from);
    }

    if ((reply_to = assoc_lookup(h, "reply_to")))
        reply_to = string_trim_whitespace(reply_to);

    if ((fcc = assoc_lookup(h, "fcc")))
        fcc = string_trim_whitespace(fcc);

    signature = assoc_lookup(h, "signature");

    if (!(alias && alias[0])) {
        session_message(session, "No alias supplied");
        generate_form(session, h);
        return;
    }

    if (!(personal && from && reply_to && fcc && signature)) {
        session_message(session,
                        "Fields missing from form (program error)");
        session_log(session,
                    ("[cmd_roles_entry] Fields missing from form "
                     "(program error)"));
        generate_form(session, h);
        return;
    }

    if (from && from[0]) {
        ADDRESS *addr = addr_parse(request->pool, from, "");
        BOOL error = T;

        if (!addr)
            session_message(session, "From Address invalid: %s", ml_errmsg());
        else if (addr && addr->next)
            session_message(session,
                            "From address must be single address");
        else if (!(addr->host && addr->host[0]))
            session_message(session, "From address must be qualified");
        else if (addr->personal && addr->personal[0])
            session_message(session,
                            "From address should not contain personal name");
        else
            error = NIL;

        if (addr)
            mail_free_address(&addr);

        if (error) {
            generate_form(session, h);
            return;
        }
    }

    if (reply_to && reply_to[0]) {
        ADDRESS *addr = addr_parse(request->pool, reply_to, "");
        ADDRESS *a = NIL;
        BOOL error = NIL;

        if (!addr) {
            session_message(session, "Reply-To Address invalid: %s",
                            ml_errmsg());
            error = T;
        } else {
            for (a = addr; a; a = a->next) {
                if (!(a->host && a->host[0])) {
                    session_message(session,
                                    "Unqualified address in Reply-To list");
                    error = T;
                    break;
                }
            }
            mail_free_address(&addr);
        }
        if (error) {
            generate_form(session, h);
            return;
        }
    }

    if (fcc && fcc[0] && !string_filename_valid(fcc)) {
        session_message(session, "Invalid Fcc name");
        generate_form(session, h);
        return;
    }

    role_update(options->role_list,
                alias, personal, from, reply_to, fcc, signature);

    session_message(session, "Updated role: \"%s\"", alias);
    options->save = T;
    session_redirect(session, request, "roles_list");
}
