/* $Cambridge: hermes/src/prayer/servers/session_config.c,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "server.h"

/* Config methods applied to running session */

/* session_config_local_domain_open() ***********************************
 *
 * Open local_domain CDB maps.
 ************************************************************************/

BOOL session_config_local_domain_open(struct config *config)
{
    struct list_item *li;

    if (config->local_domain_list == NIL)
        return (T);

    for (li = config->local_domain_list->head; li; li = li->next) {
        struct config_local_domain *cld =
            (struct config_local_domain *) li;

        if (cld->file) {
            if (cld->cdb_map)
                cdb_close(cld->cdb_map);

            if ((cld->cdb_map = cdb_open(cld->file)) == NIL) {
                log_panic("Couldn't open local_domains map file: %s\n",
                          cld->file);
                return (NIL);
            }
            log_debug("Opened CDB map for local domain: %s", cld->name);
        }
    }

    config->local_domain_time = time(NIL);
    return (T);
}

/* session_config_local_domain_ping() ***********************************
 *
 * Reopen local_domain CDB maps at periodic intervals.
 ************************************************************************/

BOOL session_config_local_domain_ping(struct config * config)
{
    struct list_item *li;
    time_t now = time(NIL);

    if (config->local_domain_list == NIL)
        return (T);

    if (config->db_ping_interval == 0)
        return (T);

    if ((config->local_domain_time + config->db_ping_interval) >= now)
        return (T);

    for (li = config->local_domain_list->head; li; li = li->next) {
        struct config_local_domain *cld =
            (struct config_local_domain *) li;

        if (cld->file) {
            if (cld->cdb_map)
                cdb_close(cld->cdb_map);

            if ((cld->cdb_map = cdb_open(cld->file)) == NIL) {
                log_panic("Couldn't open local_domains map file: %s\n",
                          cld->file);
                return (NIL);
            }
            log_debug("Reopened CDB map for local domain: %s", cld->name);
        }
    }

    config->local_domain_time = now;
    return (T);
}
