/* $Cambridge: hermes/src/prayer/session/lookup.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */

/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

struct lookup_item {
    char *userid;             /* CRSid */
    char *registered_name;    /* Registered Name on Jackdaw */
    char *display_name;       /* Local GeCOS or LDAP displayName */
    char *affiliation;        /* From local username map or LDAP "ou"   */
    char *email;              /* Constructed from CRSid or LDAP "email" */
    char *phone;              /* LDAP only */
    BOOL  cancelled;          /* Local lookups only */
};

struct lookup {
    char *query;
    struct lookup_item **entries;
    unsigned long count;
    unsigned long current;

    struct pool *master_pool;
    struct pool *pool;
    BOOL have_cancelled;
    BOOL have_phone;

    struct session *session;  /* For session_message() only */

    char *local_fullname;     /* Configuration for local lookups */
    char *local_username;
    char *local_rpasswd;
    char *local_rusername;

    char *ldap_server;       /* Configuration details for LDAP lookups */
    unsigned long ldap_port;
    char *ldap_base_dn;
    unsigned long ldap_timeout;
};

struct lookup *
lookup_create(struct session *session, struct pool *pool);

void
lookup_clear(struct lookup *lookup);

void
lookup_free(struct lookup *lookup);

BOOL
lookup_local_available(struct lookup *lookup);

BOOL
lookup_ldap_available(struct lookup *lookup);

BOOL
lookup_local(struct lookup *lookup, char *text, char *default_domain);

BOOL
lookup_ldap(struct lookup *lookup, char *text);

#define LDAP_DEFAULT_PORT (389)
