/* $Cambridge: hermes/src/prayer/session/session.h,v 1.2 2008/05/19 15:55:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* IMAP protocol allows sessions to disconnection after 30 mins idle time */
#define SESSION_DEFAULT_IMAP_TIMEOUT  (29*60)

struct session {
    /* General session stuff */
    struct pool *pool;          /* Allocate from this pool       */
    struct config *config;      /* Generate configuration        */
    BOOL debug;                 /* Debugging                     */
    BOOL want_disconnect;       /* Disconnect after this request */
    char *cwd;                  /* Current working directory     */
    char *dir_filter;           /* Filter for directory listing  */
    char *username;             /* Name of logged in user        */
    char *password;             /* Password for logged in user   */
    char *newpassword;          /* New Password logged in user */
    struct memblock *last_cmd;  /* Last command that was run     */
    struct memblock *last_help; /* Last help item                */
    struct account *account;    /* Connection to accountd server */
    struct sieve   *sieve;      /* Connection to sieve server */
    BOOL  use_sieve;            /* Use sieve rather than accountd if set */

    /* Location of servers */
    char *imapd_server;         /* Location of imap server       */
    char *accountd_server;      /* Location of accountd server   */
    char *accountd_nis_server;  /* Location of accountd NIS server */
    char *sieved_server;        /* Location of sieve server      */

    /* Some rather nasty session state */
    char *rename_foldername;    /* Name of folder to be renamed  */
    BOOL aggregate;             /* Aggregate operation           */
    BOOL reply_all;             /* Reply to all                  */
    struct filter *half_filter; /* Half build filter item        */
    char *upload_name;          /* Name for folder upload        */
    char *upload_file;          /* Temp file for folder upload   */
    char *abook_compose_name;   /* Name and email address for    */
    char *abook_compose_email;  /* Abook compose option          */
    BOOL  help_enabled;         /* Help text enabled             */
    BOOL  help_toolbar;         /* Show help for toolbar as well */

    struct log *accesslog;      /* Access log                    */
    struct log *sessionlog;     /* Session log                   */
    BOOL http_dump;             /* Temporary, remove */
    int telemetry_fd;           /* File descriptor for telemetry */
    BOOL telemetry;             /* Enable HTTP telemetry         */
    BOOL telemetry_all;         /* Enable full HTTP telemetry    */

    unsigned long sequence;     /* Session sequence number       */
    unsigned long sequence_last_change; /* Last folder change happened   */
    BOOL sequence_okay;         /* NIL: Browser history in action */

    /* HTTP Connection stuff, including request/response */
    struct request *request;    /* _Current_ request             */
    struct ipaddr *ipaddr;      /* IP address for client         */
    pid_t frontend_pid;         /* Process ID for logging        */
    BOOL use_ssl;               /* Use SSL for frontend port     */
    unsigned long frontend_port;        /* Frontend port for this session */
    unsigned long session_port; /* Backend sessionport, if used  */
    BOOL is_direct;             /* Direct connection             */
    char *url_prefix;           /* Prefix for normal urls        */
    char *url_prefix_icons;     /* Prefix for icon urls          */
    char *url_prefix_asession;  /* Base Prefix for session urls  */
    char *url_prefix_bsession;  /* Base Prefix for session urls  */
    char *url_prefix_short;     /* Prefix for shortsession urls  */
    char *url_prefix_session;   /* Prefix for session urls       */
    char *sessionid;            /* SessionID for this user       */

    /* User interface stuff */
    BOOL use_cookie;            /* Session using cookie          */
    BOOL use_short;             /* Use short URLS                */
    BOOL use_gzip;              /* Use gzip compression          */
    char *abook_parent_cmd;     /* Parent cmd for address book   */
    char *compose_parent_cmd;   /* Parent cmd for compose        */
    char *take_parent_cmd;      /* Parent cmd for abook_take     */
    char *copy_parent_cmd;      /* Parent cmd for copy           */
    BOOL compose_large;         /* Large compose window          */
    BOOL full_hdrs;             /* Display full headers          */
    struct config_theme *theme_main;    /* Main theme                    */
    struct config_theme *theme_help;    /* Help theme                    */
    struct template_vals *template_vals; /* Filled in for each new template */

    /* Folder stuff */
    char *personal_hierarchy;   /* From IMAP server NAMESPACE */
    char *hiersep;              /* From IMAP server NAMESPACE */

    char *foldername;           /* Current folder name           */
    char *other_foldername;     /* Name of "other" folder        */
    char *draft_foldername;     /* Name of "draft" folder        */
    MAILSTREAM *stream;         /* MAILSTREAM for current folder */
    MAILSTREAM *inbox_stream;   /* MAILSTREAM for inbox          */
    MAILSTREAM *other_stream;   /* MAILSTREAM for otherfolder    */
    MAILSTREAM *draft_stream;   /* MAILSTREAM for drafts         */
    MAILSTREAM *prefs_stream;   /* MAILSTREAM for preferences    */
    MAILSTREAM *xfer_stream;    /* MAILSTREAM for transfers      */
    time_t inbox_last_ping_time;        /* Time of last ping             */
    time_t other_last_ping_time;        /* Time of last ping             */
    time_t draft_last_ping_time;        /* Time of last ping             */
    time_t prefs_last_ping_time;        /* Time of last ping             */
    time_t xfer_last_ping_time;         /* Time of last ping             */

    unsigned long current;      /* Current message               */
    unsigned long last_displayed;       /* Last message to be displayed  */
    struct msgmap *zm;          /* Zoom map                      */

    struct memblock *message;   /* Status message to display     */
    struct options *options;    /* Miscellaneous user options    */
    struct lookup  *lookup;     /* Interface to lookup system    */
    struct folderlist *folderlist; /* Folderlist (replaces dircache)*/
    struct speller *speller;    /* Interface to spell checker    */
    struct draft *draft;        /* Draft message                 */
    struct draft *draft0;       /* Previous draft message        */
    struct user_agent *ua_initial;      /* Initial user agent prefs      */
    struct user_agent *user_agent;      /* Modified user agent prefs     */
};

BOOL session_log_open(struct session *session);

BOOL session_log_ping(struct session *session);

struct session *session_create(struct config *config);

void session_update_sequence(struct session *session);
void session_bump_sequence(struct session *session);

struct template_vals_urlstate *
session_extract_urlstate(struct session *session);

void
session_seed_template(struct session *session, struct template_vals *tvals);

void session_setup_urls(struct session *session);

char *session_mailbox_prefs(struct session *session, struct pool *pool);

char *session_mailbox(struct session *session, struct pool *pool,
                      char *folder);

char *session_dir(struct session *session, struct pool *pool, char *dir);


BOOL
session_login(struct session *session,
              char *username, char *password,
              unsigned long port, BOOL use_ssl,
              char *ua_options, struct ipaddr *ipaddr);

void session_setup_child(struct session *session);

void session_close_logs(struct session *session);

void session_close_streams(struct session *session);

void session_free(struct session *session);

/* void *prefs needed to break cicular dependancy */
void session_use_prefs(struct session *session, void *prefs, BOOL initial);

unsigned long session_sequence(char *seqno);

void
session_make_redirect(struct session *session,
                      struct request *request, char *location);

void
session_make_cookie_redirect(struct session *session,
                             struct request *request, char *location);

void
session_make_clear_cookie_redirect(struct session *session,
                                   struct request *request,
                                   char *location);


void session_make_session_redirect(struct session *session,
                                   struct request *request, char *cmd);

void session_make_session_cookie_redirect(struct session *session,
                                          struct request *request,
                                          char *cmd);

void
session_make_session_clear_cookie_redirect(struct session *session,
                                           struct request *request,
                                           char *cmd);

void
session_redirect(struct session *session,
                 struct request *request, char *url);

void session_record_cmd(struct session *session, char *cmd);
void session_message(struct session *session, char *fmt, ...);
void session_message_clear(struct session *session);

void session_init_last_cmd(struct session *session, unsigned long maxlen);
void session_record_last_cmd(struct session *session, char *last_cmd);
char *session_last_cmd(struct session *session);

void session_accesslog(struct session *session, struct request *request);
void session_log(struct session *session, char *fmt, ...);
void session_paniclog(struct session *session, char *fmt, ...);
void session_fatal(struct session *session, char *fmt, ...);
