/* $Cambridge: hermes/src/prayer/shared/response.h,v 1.2 2008/05/19 15:55:59 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

/* Chunk size for response header block. Typical hdr << 1024 bytes */
#define RESPONSE_HDR_BLOCK_SIZE (1024)

void response_record_version(char *version);

struct request *response_create(struct pool *p, struct iostream *stream);
void response_add_header(struct request *r, char *hdr);
void response_discard_headers(struct request *r);

void response_error(struct request *r, unsigned long status);
void response_html(struct request *r, unsigned long status);
void response_text(struct request *r, unsigned long status);
void response_raw(struct request *r, char *name, char *type,
		  unsigned long status);

BOOL response_file(struct request *request, HTTP_METHOD method,
		   char *filename, unsigned long timeout,
		   char *if_modified_since);

void response_redirect(struct request *request, char *location);
void response_cookie_redirect(struct request *request, char *location,
			      char *cookie_key, char *cookie_value,
			      char *path, char *domain, BOOL secure);

void response_clear_cookie_redirect(struct request *request, char *location,
				    char *cookie_key, char *cookie_value,
				    char *path, char *domain, BOOL secure);

void response_0_9_error(struct request *request);

void response_send(struct request *request);
