/* $Cambridge: hermes/src/prayer/cmd/cmd_delete.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_delete(struct session *session)
{
    struct request *request = session->request;
    MAILSTREAM *stream = session->stream;
    unsigned long msgno, msguid;

    if (request->argc < 2) {
        session_redirect(session, request, "error");
        return;
    }

    msgno = atoi(request->argv[1]);
    msguid = atoi(request->argv[2]);

    if (!(msgno = stream_check_uid(session, stream, msgno, msguid))) {
        session_redirect(session, request, "restart");
        return;
    }

    if (!ml_flag
        (session, stream, string_itoa_tmp(msgno), "\\DELETED", ST_SET)) {
        session_message(session, "Failed to delete message number %lu: %s",
                        msgno, ml_errmsg());
        session_log(session,
                    "[cmd_delete] Failed to delete message number %lu from %s: %s",
                    msgno, session->foldername, ml_errmsg());
        session_redirect(session, request, "restart");
        return;
    }

    session_message(session, "Deleted message number %lu", msgno);
    session_log(session,
                "[cmd_delete] Deleted message number %lu from %s",
                msgno, session->foldername);

    session_redirect(session, request, "list");
}
