/* $Cambridge: hermes/src/prayer/cmd/cmd_list_sort.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

void cmd_list_sort(struct session *session)
{
    struct request *request = session->request;
    int mode = msgmap_current_sort_mode(session->zm);
    BOOL reverse = msgmap_sort_reverse(session->zm);
    char *verb;
    char *text;

    if (request->argc < 2) {
        session_redirect(session, request, "list");
        return;
    }

    if (!strcmp(request->argv[1], "reverse")) {
        if (msgmap_sort_reverse(session->zm))
            msgmap_sort_reverse_disable(session->zm);
        else
            msgmap_sort_reverse_enable(session->zm);
    } else if (!strcmp(request->argv[1], "arrival")) {
        if (mode == ARRIVAL) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, ARRIVAL);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "date")) {
        if (mode == DATE) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, DATE);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "from")) {
        if (mode == FROM) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, FROM);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "to")) {
        if (mode == TO) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, TO);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "cc")) {
        if (mode == CC) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, CC);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "size")) {
        if (mode == SIZE) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, SIZE);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "subject")) {
        if (mode == SUBJECT) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, SUBJECT);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "references")) {
        if (mode == REFERENCES) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, REFERENCES);
            msgmap_sort_reverse_disable(session->zm);
        }
    } else if (!strcmp(request->argv[1], "orderedsubject")) {
        if (mode == ORDEREDSUBJECT) {
            if (reverse)
                msgmap_sort_reverse_disable(session->zm);
            else
                msgmap_sort_reverse_enable(session->zm);
        } else {
            msgmap_sort_mode(session->zm, ORDEREDSUBJECT);
            msgmap_sort_reverse_disable(session->zm);
        }
    }

    verb = "Sorting";

    switch (msgmap_current_sort_mode(session->zm)) {
    case ARRIVAL:
        text = "arrival time";
        break;
    case DATE:
        text = "Date";
        break;
    case FROM:
        text = "From";
        break;
    case TO:
        text = "To";
        break;
    case CC:
        text = "Cc";
        break;
    case SIZE:
        text = "Size";
        break;
    case SUBJECT:
        text = "Subject";
        break;
    case REFERENCES:
        verb = "Threading";
        text = "Reference";
        break;
    case ORDEREDSUBJECT:
        verb = "Threading";
        text = "Ordered Subject";
        break;
    default:
        verb = "Sorting";
        text = "(unknown)";
        break;
    }

    if (msgmap_sort_reverse(session->zm))
        session_message(session,
                        "%s by reverse %s (current message: %lu)",
                        verb, text, session->current);
    else
        session_message(session,
                        "%s by %s (current message: %lu)",
                        verb, text, session->current);

    msgmap_invalidate(session->zm);
    session_redirect(session, request, "list");
}
