/* $Cambridge: hermes/src/prayer/cmd/cmd_upload_select.c,v 1.2 2008/05/19 15:55:54 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "prayer_session.h"

static BOOL upload(struct session *session,
                   char *name, char *data, unsigned long len)
{
    struct config *config = session->config;
    struct request *request = session->request;
    char *tmpfname;
    FILE *tmpfile;
    int fd;

    tmpfname = pool_printf(request->pool, "%s/%s:%lu:XXXXXX",
                           config->tmp_dir, session->username,
                           (unsigned long) getpid());

    if ((fd = mkstemp(tmpfname)) < 0)
        return (NIL);

    /* Transfer data to temporary file */
    if ((tmpfile = fdopen(fd, "w")) == NIL) {
        session_message(session, "Failed to open temporary file");
        return (NIL);
    }

    while (len > 0) {
        fputc((*data) ? (*data) : ' ', tmpfile);

        data++;
        len--;
    }
    fclose(tmpfile);

    if (session->upload_file) {
        unlink(session->upload_file);
        string_free((void **) &session->upload_file);
    }
    session->upload_file = pool_strdup(NIL, tmpfname);
    return (T);
}

static BOOL
process_upload_request(struct session * session, struct request * request)
{
    char *s, *disp;
    char *start, *end;
    struct assoc *hdrs = assoc_create(request->pool, 16, T);
    char *name = NIL;
    unsigned long len;

    request_decode_post_multipart(request, hdrs, &start, &end);
    *end = '\0';

    if (end > start)
        len = (char *) end - (char *) start;
    else
        len = 0;

    if ((disp = assoc_lookup(hdrs, "content-disposition"))) {
        for (s = disp; *s; s++) {
            if (!strncasecmp(s, "filename=\"", strlen("filename=\""))) {
                name = s = s + strlen("filename=\"");
                while (*s && (*s != '"'))
                    s++;
                *s = '\0';
                break;
            }
        }
    }
    if (name && name[0]) {
        if ((s = strrchr(name, '/')))
            name = s + 1;
        else if ((s = strrchr(name, '\\')))
            name = s + 1;
    } else
        name = "Upload";

    if (!upload(session, name, start, len))
        return (NIL);

    session_message(session, "Copied mailbox to halfway point");
    session->upload_name = pool_strdup(NIL, name);
    return (T);
}

/* ====================================================================== */

void cmd_upload_select(struct session *session)
{
    struct template_vals *tvals = session->template_vals;
    struct folderlist *fl = folderlist_fetch(session);
    struct prefs *prefs = session->options->prefs;
    BOOL suppress_dotfiles = prefs->suppress_dotfiles;
    struct request *request = session->request;
    struct buffer *b = request->write_buffer;
    struct folderitem *fi;
    char *name;

    if (request->method == POST) {
        if (!process_upload_request(session, request)) {
            session_redirect(session, request, "restart");
            return;
        }
    }

    if ((request->argc == 3) && !strcmp(request->argv[1], "toggle")) {
        name = string_canon_decode(request->argv[2]);
        fi   = folderlist_lookup(folderlist_fetch(session), name);
        if (fi) {
            if (fi->expanded) {
                session_message(session, "Collapsed \"%s\"", name);
                fi->expanded = NIL;
            } else {
                folderlist_expand(session, fi);
                session_message(session, "Expanded \"%s\"", name);
                fi->expanded = T;
            }
        }
    }

    folderlist_template_vals_tree(fl, suppress_dotfiles, tvals, "@folder");
    folderlist_template_vals_list(fl, suppress_dotfiles, tvals,
                                  T, "@dirlist");
    if (session->upload_name)
        template_vals_string(tvals, "$upload_name", session->upload_name);

    session_seed_template(session, tvals);
    template_expand("upload_select", tvals, b);

    response_html(request, 200);
}
