/* $Cambridge: hermes/src/prayer/shared/html_common.c,v 1.3 2008/05/29 10:10:25 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#include "shared.h"

/* Set of routines for generating chunks of HTML markup. */

/* html_common_start() ***************************************************
 *
 * HTML header
 ************************************************************************/

void
html_common_start(struct config *config, struct buffer *b, char *title)
{
    struct config_theme *theme = config->theme_main;

    bputs(b, ("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\""
              " \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">"CRLF));
    bputs(b, ("<html xmlns=\"http://www.w3.org/1999/xhtml\""
              " lang=\"en\" xml:lang=\"en\">"CRLF));
    bputs(b, "<head>"CRLF);
    bprintf(b, "<title>Webmail service: %s</title>" CRLF, title);
    bputs(b, "<meta name=\"robots\" content=\"none\" />" CRLF);
    bputs(b, ("<meta http-equiv=\"Content-Type\" "
              "content=\"text/html; charset=UTF-8\" />" CRLF));
    bprintf(b, ("<link rel=\"stylesheet\""
                " href=\"/static/%s.css\""
                " type=\"text/css\" />"CRLF), theme->name);
    bputs(b, "</head>" CRLF);
    bputs(b, "<body>"CRLF);
}

/* html_common_end() *****************************************************
 *
 * End of HTML body
 ************************************************************************/

void html_common_end(struct buffer *b)
{
    bprintf(b, "</body></html>" CRLF);
}

/* ====================================================================== */

/* html_common_quote_char() *********************************************
 *
 * Print character replacing significant HTML characters with eqivalent
 * escape sequences.
 * translation stuff.
 *     b: Buffer
 *     c: Character to print
 ***********************************************************************/

static void html_common_quote_char(struct buffer *b, unsigned char c)
{
    if (c > 127) {
        bprintf(b, "&#%lu;", (unsigned long) c);
    } else
        switch (c) {
        case ' ':
            bputs(b, "&nbsp;");
            break;
        case '"':
            bputs(b, "&quot;");
            break;
        case '&':
            bputs(b, "&amp;");
            break;
        case '<':
            bputs(b, "&lt;");
            break;
        case '>':
            bputs(b, "&gt;");
            break;
        default:
            bputc(b, c);
        }
}

/* html_common_quote() ***************************************************
 *
 * Print string replacing significant HTML characters with eqivalent
 * escape sequences.
 * translation stuff.
 *     b: Buffer
 *     t: String to print
 ***********************************************************************/

void html_common_quote_string(struct buffer *b, char *t)
{
    unsigned char *s = (unsigned char *) t;
    unsigned char c;

    if (!s)
        bputs(b, "(nil)");
    else
        while ((c = *s++))
            html_common_quote_char(b, c);
}
