/* $Cambridge: hermes/src/prayer/session/account.h,v 1.3 2008/09/16 09:59:58 dpc22 Exp $ */
/************************************************
 *    Prayer - a Webmail Interface              *
 ************************************************/

/* Copyright (c) University of Cambridge 2000 - 2008 */
/* See the file NOTICE for conditions of use and distribution. */

#define ACCOUNT_BLOCKSIZE     (8192)

struct account {
    struct pool *pool;          /* Allocation pool */
    struct session *session;    /* Pointer back to parent session */
    struct iostream *stream;    /* Connection to main account server */
    time_t last_ping;           /* Last access time for timeouts */
    struct iostream *nis_stream;        /* Connection to NIS account server */
    time_t nis_last_ping;       /* Last access time for timeouts */
    unsigned long bused;        /* Quota limit: Block use */
    unsigned long blimit;       /* Quota limit: Block limit */
    unsigned long iused;        /* Quota limit: Inode use */
    unsigned long ilimit;       /* Quota limit: Iode limit */
    char *fullname;             /* Fullname retrieved from server */

    /* Mail processing stuff */
    BOOL mail_checked;          /* T => have checked mail status */
    BOOL vacation_enabled;      /* T => vacation message enabled */
    char *vacation_msg;         /* Current vacation message  */
    char *vacation_aliases;     /* Vacation aliases list     */
    int   vacation_days;        /* Days argument for Sieve   */
    struct list *filter_list;   /* Active list of filters    */
    struct list *block_list;    /* Active list of blocks     */
    BOOL spam_enabled;          /* T => spam filtering is enabled */
    int  spam_threshold;        /* Filtering level */
    BOOL spam_threshold_valid;  /* T => threshold valid meaningful */
    int  spam_timeout;          /* Spam_purge timeout, in days */
    BOOL spam_purge_enabled;    /* Purge spam folder */
    int  spam_purge_timeout;    /* Spam_purge timeout, in days */
    BOOL spam_purge_valid;      /* T => timeout valid meaningful */
    char *spam_whitelist;       /* Spam whitelist (one addr per line) */
    BOOL redirect_enabled;      /* T => Redirect enabled */
    BOOL redirect_copy;         /* T => Leave copy on server */
    char *redirect_address;     /* Target address(es) for redirection */

    /* Server response */
    BOOL have_message;
    struct memblock *message;
    BOOL sieve_have_auto;       /* T => Have Sieve Auto file */
};

struct account *account_create(struct pool *pool, struct session *session);

void account_free(struct account *account);

void account_close(struct account *account);

void account_timeout_close(struct account *account);

void account_message(struct account *account, char *fmt, ...);

char *account_fetch_message(struct account *account);

BOOL
account_filter_add(struct account *account, struct filter *filter);

BOOL
account_filter_remove(struct account *account, unsigned long offset);

BOOL
account_block_add(struct account *account, struct filter *filter);

BOOL
account_block_remove(struct account *account, unsigned long offset);

BOOL
account_change_password(struct account *account,
                        struct pool *pool, char *old, char *new);

char *account_fullname(struct account *account, struct pool *pool);

BOOL
account_change_fullname(struct account *account,
                        struct pool *pool, char *new);

BOOL
account_check_quota(struct account *account, struct pool *pool);

BOOL
account_mail_check(struct account *account, struct pool *pool);

BOOL
account_mail_update(struct account *account, struct pool *pool);

BOOL
account_vacation_update(struct account *account, struct pool *pool);

char *account_vaclog_fetch(struct account *account, struct pool *pool);

BOOL
account_vaclog_clear(struct account *account, struct pool *pool);

char *account_abook_get(struct account *account, struct pool *pool);

BOOL
account_abook_put(struct account *account, struct pool *pool, char *text);
