/*****
*
* Copyright (C) 2000, 2002 Yoann Vandoorselaere <yoann@prelude-ids.org>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#include <stdio.h>

#include "detect.h"

static plugin_detect_t plugin;
static subscribtion_t subscribtion[] = {
        { p_all, NULL },
        { p_end, NULL },
};



static int is_enabled = 0;
static int out_stderr = 0;



static void debug_run(packet_container_t *packet) 
{
        nids_alert_t alert;

        nids_alert_init(&alert);
        idmef_string_set_constant(&alert.classification.name, "Debug plugin");
                
        nids_alert((plugin_generic_t *) &plugin, packet, &alert, 
                   "This is a debuging message by the debug plugin");

        if ( out_stderr )
                fprintf(stderr, "Debug: packet received, packet=%p\n", packet);
}



static int set_debug_state(prelude_option_t *opt, const char *optarg) 
{
        int ret;
        
        if ( is_enabled == 1 ) {
                ret = plugin_unsubscribe((plugin_generic_t *) &plugin);
                if ( ret < 0 )
                        return prelude_option_error;
                
                is_enabled = 0;
        }

        else {
                ret = plugin_subscribe((plugin_generic_t *) &plugin);
                if ( ret < 0 )
                        return prelude_option_error;

                is_enabled = 1;
        }
        
        return prelude_option_success;
}




static int get_debug_state(char *buf, size_t size) 
{
        snprintf(buf, size, "%s", (is_enabled == 1) ? "enabled" : "disabled");
        return prelude_option_success;
}



static int get_output(char *buf, size_t size)
{
        snprintf(buf, size, "%s", (out_stderr) ? "enabled" : "disabled");
        return prelude_option_success;
}


static int set_output(prelude_option_t *opt, const char *optarg) 
{
        /*
         * enable or disable depending on the current value.
         */
        out_stderr = !out_stderr;        
        return prelude_option_success;
}




plugin_generic_t *plugin_init(int argc, char **argv)
{
        prelude_option_t *opt;
        
        opt = prelude_option_add(NULL, CLI_HOOK|CFG_HOOK, 0, "debug", "Debug plugin option",
                                 no_argument, set_debug_state, get_debug_state);

        prelude_option_add(opt, CLI_HOOK|CFG_HOOK, 'p', "print",
                           "Output to stderr when plugin is called", no_argument, set_output,
                           get_output);
        
        plugin_set_name(&plugin, "Debug");        
        plugin_set_author(&plugin, "Yoann Vandoorselaere");
        plugin_set_contact(&plugin, "yoann@prelude-ids.org");
        plugin_set_desc(&plugin, "Send an alert for each packet.");
        plugin_set_running_func(&plugin, debug_run);
        plugin_set_subscribtion(&plugin, subscribtion);
        
        return (plugin_generic_t *) &plugin;
}





