%{

#include <rules.h>
#include <rules-operations.h>
#include <rules-parsing.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

static void
yyerror(char *msg)
{

}                                                                                                                                      
extern int yylex(void);

%}

%union {

	parameters_t *parameters;
	rules_t *rules;

}

%type <parameters> STR l_str ip port param
%type <rules> rule head option l_option options

%token STR TO_DIR FROM_DIR BI_DIR

%left ','
%nonassoc '!' 

%start rule

%%

rule:	head options			{ rule_parsed = rules_and( $1, $2); }
	;

/* String */

l_str:   STR				{ $$ = $1; }
       | l_str ',' l_str		{ $$ = signature_parser_link_parameters( $1, $3 ); }
       | '[' l_str ']'			{ $$ = $2; }
       | '!' l_str			{ $$ = signature_parser_inverse_parameters( $2 ); }
       ;

/* Head */

ip:	l_str				{ $$ = $1; }
	;

port:	l_str				{ $$ = $1; }
	;

head:	  ip port TO_DIR ip port	{
						rules_t *rules = NULL, *tmp;

						if (signature_parser_parse_key("ipsrc", $1, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );
						if (signature_parser_parse_key("portsrc", $2, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );
						if (signature_parser_parse_key("ipdst", $4, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );
						if (signature_parser_parse_key("portdst", $5, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );

						signature_parser_free_parameters( $1 );
						signature_parser_free_parameters( $2 );
						signature_parser_free_parameters( $4 );
						signature_parser_free_parameters( $5 );

						$$ = rules;
					}
						
	| ip port FROM_DIR ip port	{
						rules_t *rules = NULL, *tmp;

						if (signature_parser_parse_key("ipdst", $1, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );
						if (signature_parser_parse_key("portdst", $2, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );

						if (signature_parser_parse_key("ipsrc", $4, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );
						if (signature_parser_parse_key("portsrc", $5, &tmp) < 0) YYABORT;
						rules = rules_and( rules, tmp );

						signature_parser_free_parameters( $1 );
						signature_parser_free_parameters( $2 );
						signature_parser_free_parameters( $4 );
						signature_parser_free_parameters( $5 );

						$$ = rules;
					}

	| ip port BI_DIR ip port	{
						rules_t *rules1 = NULL, *rules2 = NULL, *tmp;

						if (signature_parser_parse_key("ipsrc", $1, &tmp) < 0) YYABORT;
						rules1 = rules_and( rules1, tmp );
						if (signature_parser_parse_key("ipdst", $1, &tmp) < 0) YYABORT;
						rules2 = rules_and( rules2, tmp );
						if (signature_parser_parse_key("portsrc", $2, &tmp) < 0) YYABORT;
						rules1 = rules_and( rules1, tmp );
						if (signature_parser_parse_key("portdst", $2, &tmp) < 0) YYABORT;
						rules2 = rules_and( rules2, tmp );

						if (signature_parser_parse_key("ipsrc", $4, &tmp) < 0) YYABORT;
						rules2 = rules_and( rules2, tmp );
						if (signature_parser_parse_key("ipdst", $4, &tmp) < 0) YYABORT;
						rules1 = rules_and( rules1, tmp );
						if (signature_parser_parse_key("portsrc", $5, &tmp) < 0) YYABORT;
						rules2 = rules_and( rules2, tmp );
						if (signature_parser_parse_key("portdst", $5, &tmp) < 0) YYABORT;
						rules1 = rules_and( rules1, tmp );

						signature_parser_free_parameters( $1 );
						signature_parser_free_parameters( $2 );
						signature_parser_free_parameters( $4 );
						signature_parser_free_parameters( $5 );

						$$ = rules_or( rules1, rules2 );
					}
	| ip port TO_DIR ip error	{ signature_parser_set_error( "Expecting Port"); YYABORT; }
	| ip port FROM_DIR ip error	{ signature_parser_set_error( "Expecting Port"); YYABORT; }
	| ip port BI_DIR ip error	{ signature_parser_set_error( "Expecting Port"); YYABORT; }
	| ip port TO_DIR error		{ signature_parser_set_error( "Expecting IP"); YYABORT; }
	| ip port FROM_DIR error	{ signature_parser_set_error( "Expecting IP"); YYABORT; }
	| ip port BI_DIR error		{ signature_parser_set_error( "Expecting IP"); YYABORT; }
	| ip port error			{ signature_parser_set_error( "Invalid directional operator" ); YYABORT; }
	| ip error			{ signature_parser_set_error( "Expecting Port"); YYABORT; }
	| error				{ signature_parser_set_error( "Expecting IP" ); YYABORT; }

	;

/* Options */

param:	  ':' l_str			{ $$ = $2; }
	|				{ $$ = NULL; }
	;

option:	STR param ';'  			{ 
						int ret = signature_parser_parse_key( $1->str, $2, &( $$ ) );
						signature_parser_free_parameters( $1 );
						signature_parser_free_parameters( $2 );
						if (ret < 0) YYABORT;
					}
	| STR param error		{ signature_parser_set_error( "Expecting ;" ); YYABORT; }
	| ';' 				{ $$ = NULL; }
	;


l_option:   option			{ $$ = $1; }
	  | l_option option		{ $$ = rules_and( $1, $2 ); }
	  ;	
	
options:   '(' l_option ')'		{ $$ = $2; }
	 | '(' l_option error		{ signature_parser_set_error( "Expecting )" ); YYABORT; }
	 | error			{ signature_parser_set_error( "Expecting ("); YYABORT; }
	 |				{ $$ = NULL; }
	 ;
	 

%%


