/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: listnode.cc,v $
 * Revision 1.1.1.1  2001/01/30 18:36:27  slash
 * Initial release.
 *
 */

#include "main.h"
#include "itemnode.h"
#include "listnode.h"


//---------------------------------------------------------------------------
ListNode::ListNode(unsigned int level,
                   int with_left_margin) : EnvironmentNode()
{
    is_sub_list_.clear();
    level_ = level;
    with_left_margin_ = with_left_margin;
    max_length_ = 0;
}

//---------------------------------------------------------------------------
ListNode::~ListNode()
{
    is_sub_list_.clear();
}


//---------------------------------------------------------------------------
void ListNode::writeHTML(int number_of_items) const
{
    if (number_of_items < 0) {
        writeHTMLAllItems(number_of_items);
    } else {
        if ((unsigned)number_of_items > number_of_html_steps_) {
            number_of_items = number_of_html_steps_;
        }
        writeHTMLItems(number_of_items);
    }
}

//---------------------------------------------------------------------------
void ListNode::writeHTMLAllItems(int style) const
{
    writeHTMLHeader();

    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        if (is_sub_list_[i] == 1) {
            // child_nodes_[i] is a derivated ListNode.
            child_nodes_[i]->writeHTML(style);

        } else {
            // child_nodes_[i] is an ItemNode.
            child_nodes_[i]->writeHTML(style == -1 ?
                                       ItemNode::NORMAL :
                                       ItemNode::WEAK);
        }
    }
    
    writeHTMLFooter();
}

//---------------------------------------------------------------------------
void ListNode::writeHTMLItems(int number_of_items) const
{
    writeHTMLHeader();

    unsigned int i = 0;
    while (number_of_items > 0) {
        if (is_sub_list_[i] == 1) {
            // child_nodes_[i] is a derivated ListNode.
            ListNode *sub_list = ((ListNode*)child_nodes_[i++]);
            if (sub_list->isHTMLStepped() == 0) {
                sub_list->writeHTML(number_of_items-- == 1 ? -1 : -2);

            } else {
                if (sub_list->getNumberOfHTMLSteps() < (unsigned)number_of_items) {
                    // All items in the sub-itemization should be written WEAK.
                    sub_list->writeHTML(-2);
                } else {
                    // Write number_of_items items of the sub-itemization.
                    sub_list->writeHTML(number_of_items);
                }

                number_of_items -= sub_list->getNumberOfHTMLSteps();
            }
            
        } else {
            // child_nodes_[i] is an ItemNode.
            child_nodes_[i++]->writeHTML(number_of_items-- == 1 ?
                                         ItemNode::NORMAL :
                                         ItemNode::WEAK);
        }
    }

    writeHTMLFooter();
}

//---------------------------------------------------------------------------
unsigned int ListNode::getLength() const
{
    unsigned int length = 0;
    unsigned int item_length;

    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        item_length = child_nodes_[i]->getLength();
        if (item_length > length) {
            length = item_length;
        }
    }

    return length;
}

