/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: outputfilter.cc,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:18  slash
 * Initial release.
 *
 */

#include "main.h"
#include "outputfilter.h"


void OutputFilter::writeHTML(const char *text,
                             int skip_first_newlines)
{
    for (int i=0; text[i] != '\0'; i++) {
        if ((skip_first_newlines != 1) || (text[i] != '\n')) {
            // Skip the first newline's.
            skip_first_newlines = 0;
            switch (text[i]) {
              case '<': Output_ << "&lt;"; break;
              case '>': Output_ << "&gt;"; break;
              case '&': Output_ << "&amp;"; break;
              case '': Output_ << "&auml;"; break;
              case '': Output_ << "&ouml;"; break;
              case '': Output_ << "&uuml;"; break;
              case '': Output_ << "&Auml;"; break;
              case '': Output_ << "&Ouml;"; break;
              case '': Output_ << "&Uuml;"; break;
              case '': Output_ << "&szlig;"; break;
              default:  Output_ << text[i]; break;
            }
        }
    }
}

//---------------------------------------------------------------------------
void OutputFilter::writeLaTeX(const char *text,
                              int latex_encode)
{
    if (latex_encode == 0) {
        Output_ << text;

    } else {
        int skip = 1;
        for (int i=0; text[i] != '\0'; i++) {
            // Skip the first newline's.
            if ((skip != 1) || (text[i] != '\n')) {
                skip = 0;
                switch (text[i]) {
                  case '<': Output_ << "\\(<\\)"; break;
                  case '>': Output_ << "\\(>\\)"; break;
                  case '#':
                  case '$':
                  case '%':
                  case '&':
                  case '_':
                  case '{':
                  case '}': Output_ << "\\" << text[i]; break;
                  default:  Output_ << text[i]; break;
                }
            }
        }
    }
}

//---------------------------------------------------------------------------
void OutputFilter::writeXML(const char *text)
{
    for (int i=0; text[i] != '\0'; i++) {
        switch (text[i]) {
          case '<': Output_ << "&lt;"; break;
          case '>': Output_ << "&gt;"; break;
          case '&': Output_ << "&amp;"; break;
          default:  Output_ << text[i]; break;
        }
    }
}

