//
//  PRImageView.m
//  PRICE
//
//  Created by Riccardo Mottola on Thu Dec 12 2002.
//  Copyright (c) 2002-2003 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRImageView.h"


@implementation PRImageView


- (void)drawRect:(NSRect)rect
{
    NSMutableArray *dragTypes;
    
    [super drawRect:rect];
    /* init copy&paste */
    dragTypes = [NSMutableArray arrayWithObjects:NSColorPboardType, NSFilenamesPboardType, nil];
    [dragTypes addObjectsFromArray:[NSImage imagePasteboardTypes]];
    [self registerForDraggedTypes:dragTypes];
}

- (void)scaleFrameBy:(float)scale
{
    NSSize imageSize;
    NSAffineTransform *at;
    
    imageSize = [[self image] size];
    at = [NSAffineTransform transform];
    [at scaleBy:scale];
    
    [self setFrameSize:[at transformSize:imageSize]];
    [self setNeedsDisplay:YES];
}


-(void) dealloc
{
    [super dealloc];
}

@end
