//
//  PRTransforms.m
//  PRICE
//
//  Created by Riccardo Mottola on Mon Dec 23 2002.
//  Copyright (c) 2002-2003-2004 Carduus. All rights reserved.
//
// This program is free software; you can redistribute it and/or modify it under the terms of the version 2 of the GNU General Public License as published by the Free Software Foundation.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

#import "PRTransforms.h"


@implementation PRTransforms

- (NSImage *)transposeImage:(NSImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        if ([srcImageRep samplesPerPixel] == 2)
        {
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            printf("Color image with alpha\n");
            return srcImage;
        }
    }
    else
    {
        if ([srcImageRep samplesPerPixel] == 1)
        {
            printf("Grayscale image\n");
            /* allocate destination image and its representation */
            destImage = [[NSImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
            destImageRep = [[[NSBitmapImageRep alloc]
                        initWithBitmapDataPlanes:NULL
                        pixelsWide:h
                        pixelsHigh:w
                        bitsPerSample:8
                        samplesPerPixel:1
                        hasAlpha:NO
                        isPlanar:NO
                        colorSpaceName:NSCalibratedWhiteColorSpace
                        bytesPerRow:0
                        bitsPerPixel:0]
                    autorelease];
    
            srcData = [srcImageRep bitmapData];
            destData = [destImageRep bitmapData];
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (x * h + y);
                    p2[0] = p1[0];
                }
        }
        else
        {
            printf("Color image\n");
            /* allocate destination image and its representation */
            destImage = [[NSImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
            destImageRep = [[[NSBitmapImageRep alloc]
                        initWithBitmapDataPlanes:NULL
                        pixelsWide:h
                        pixelsHigh:w
                        bitsPerSample:8
                        samplesPerPixel:3
                        hasAlpha:NO
                        isPlanar:NO
                        colorSpaceName:NSCalibratedRGBColorSpace
                        bytesPerRow:0
                        bitsPerPixel:0]
                    autorelease];
    
            srcData = [srcImageRep bitmapData];
            destData = [destImageRep bitmapData];
            for (y = 0; y < h; y++)
                for (x = 0; x < w; x++)
                {
                    p1 = srcData + bytesPerPixel * (y * w + x);
                    p2 = destData + bytesPerPixel * (x * h + y);
                    p2[0] = p1[0];
                    p2[1] = p1[1];
                    p2[2] = p1[2];
                }
        }
    }

    
    [destImage addRepresentation:destImageRep];
    return destImage;
}

- (NSImage *)rotateImage90:(NSImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
    if (isColorImage)
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
    else /* greyscale */
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((w-x-1) * h + y);
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((w-x-1) * h + y);
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    return destImage;
}

- (NSImage *)rotateImage180:(NSImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColorImage)
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
    else /* greyscale */
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + (w-x-1));
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + (w-x-1));
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    return destImage;
}


- (NSImage *)rotateImage270:(NSImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(h, w)]; /* we swap h and w */
    if (isColorImage)
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
    else /* greyscale */
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:h
                    pixelsHigh:w
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (x * h + (h-y-1));
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (x * h + (h-y-1));
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    return destImage;
}

- (NSImage *)flipImageVert:(NSImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColorImage)
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
    else /* greyscale */
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + x);
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * ((h-y-1) * w + x);
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    return destImage;
}

- (NSImage *)flipImageHoriz:(NSImage *)srcImage
{
    NSBitmapImageRep *srcImageRep;
    NSImage *destImage;
    NSBitmapImageRep *destImageRep;
    int w, h;
    int x, y;
    unsigned char *srcData;
    unsigned char *destData;
    unsigned char *p1, *p2;
    int bytesPerPixel;
    BOOL isColorImage;
    BOOL imageHasAlpha;
    
    
    /* get source image representation and associated information */
    srcImageRep = [NSBitmapImageRep imageRepWithData:[srcImage TIFFRepresentation]];
    
    w = [srcImageRep pixelsWide];
    h = [srcImageRep pixelsHigh];
    bytesPerPixel = [srcImageRep bitsPerPixel] /8;
    
    
    /* execute the actual transposition */
    if ([srcImageRep hasAlpha])
    {
        imageHasAlpha = YES;
        if ([srcImageRep samplesPerPixel] == 2)
        {
            isColorImage = NO;
            printf("Grayscale image with alpha\n");
            return srcImage;
        }
        else {
            isColorImage = YES;
            printf("Color image with alpha\n");
            return srcImage;
        }
    } else
    {
        imageHasAlpha = NO;
        if ([srcImageRep samplesPerPixel] == 1)
            isColorImage = NO;
        else
            isColorImage = YES;
    }
    
    destImage = [[NSImage alloc] initWithSize:NSMakeSize(w, h)];
    if (isColorImage)
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:3
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedRGBColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];
    else /* greyscale */
        destImageRep = [[[NSBitmapImageRep alloc]
                    initWithBitmapDataPlanes:NULL
                    pixelsWide:w
                    pixelsHigh:h
                    bitsPerSample:8
                    samplesPerPixel:1
                    hasAlpha:imageHasAlpha
                    isPlanar:NO
                    colorSpaceName:NSCalibratedWhiteColorSpace
                    bytesPerRow:0
                    bitsPerPixel:0]
                autorelease];

    srcData = [srcImageRep bitmapData];
    destData = [destImageRep bitmapData];
    
    if (isColorImage)
    {
        NSLog(@"Color Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (y * w + (w-x-1));
                p2[0] = p1[0];
                p2[1] = p1[1];
                p2[2] = p1[2];
            }
    } else
    {
        NSLog(@"Greyscale Image");
        for (y = 0; y < h; y++)
            for (x = 0; x < w; x++)
            {
                p1 = srcData + bytesPerPixel * (y * w + x);
                p2 = destData + bytesPerPixel * (y * w + (w-x-1));
                p2[0] = p1[0];
            }
    }
    [destImage addRepresentation:destImageRep];
    return destImage;
}


@end
