;;;; $Id: prime-log.el,v 1.1 2003/05/31 19:37:21 komatsu Exp $

(require 'prime-engine)

(defcustom prime-log-filename "/tmp/prime.log"
  "Filename for Debugging of PRIME-el.")
(defcustom prime-log-mode nil
  "Non nil means a logging of PRIME is active.")

(defvar prime-log-spool-string "")

(defun prime-log-mode ()
  (interactive)
  (if prime-log-mode
      (prime-log-mode-off)
    (prime-log-mode-on)
    ))

(defun prime-log-mode-on ()
  (interactive)
  (setq prime-log-mode t)
  (ad-enable-advice 'prime-server-search
		    'before 'prime-log-advice-server-search)
  (ad-enable-advice 'prime-engine-get-cands
		    'after  'prime-log-advice-engine-get-cands)
  (ad-enable-advice 'prime-server-select
		    'after  'prime-log-advice-server-select)
  (ad-activate 'prime-server-search)
  (ad-activate 'prime-engine-get-cands)
  (ad-activate 'prime-server-select)
  (and (interactive-p)
       (message "Start Logging for PRIME"))
  )

(defun prime-log-mode-off ()
  (interactive)
  (setq prime-log-mode nil)
  (ad-disable-advice 'prime-server-search
		     'before 'prime-log-advice-server-search)
  (ad-disable-advice 'prime-engine-get-cands
		     'after  'prime-log-advice-engine-get-cands)
  (ad-disable-advice 'prime-server-select
		     'after  'prime-log-advice-server-select)
  (ad-activate 'prime-server-search)
  (ad-activate 'prime-engine-get-cands)
  (ad-activate 'prime-server-select)
  (and (interactive-p)
       (message "Stop Logging for PRIME"))
  )

(defadvice prime-server-search
  (before prime-log-advice-server-search disable)
  "Advice for logging."
  (prime-log-write-input-pattern pattern context)
  )

(defadvice prime-engine-get-cands
  (after prime-log-advice-engine-get-cands disable)
  "Advice for logging."
  (prime-log-write-candidates (prime-engine-id engine) ad-return-value)
  )

(defadvice prime-server-select
  (after prime-log-advice-server-select disable)
  "Advice for logging."
  (prime-log-write-select word)
  )

;;;; ------------------------------------------------------------
;;;; Internal Functions
;;;; ------------------------------------------------------------

;;; input-pattern
(defun prime-log-write-input-pattern (pattern &optional context)
  (setq prime-log-spool-string
	(concat prime-log-spool-string
		(prime-log-format-input-pattern pattern context)
		))
  )

(defun prime-log-format-input-pattern (pattern &optional context)
  ;; 0: $B;~4V(B, ($B6uGr(B), $BF~NO%Q%?!<%s(B, $B%3%s%F%-%9%H(B, $BC14A;z(B
  (format "0:%s\t\t%s\t%s\t%s\n"
	  (format-time-string "%s")
	  pattern
	  (or context "")
	  (if prime-conv-exact-p "exact" "noexact"))
  )

;;; candidates by one engine
(defun prime-log-write-candidates (engine-name cands-list)
  (and cands-list
       (setq prime-log-spool-string
	     (concat prime-log-spool-string
		     (prime-log-format-candidates engine-name cands-list)
		     ))
       ))

(defun prime-log-format-candidates (engine-name cands-list)
  ;; |, $B%(%s%8%sL>(B, $B8uJd(B
  (format "|\t%s\t%s\n"
	  engine-name
	  (mapconcat 'identity cands-list "\t"))
  )

;;; selected word
(defun prime-log-write-select (word)
  (setq prime-log-spool-string
	(concat prime-log-spool-string
		(prime-log-format-select word prime-pat prime-context)
		))
  (mell-string-append-to-file prime-log-spool-string prime-log-filename)
  (setq prime-log-spool-string "")
  )

(defun prime-log-format-select (word pattern &optional context)
  ;; 1: $B;~4V(B, $BF~NOC18l(B, $BF~NO%Q%?!<%s(B, $B%3%s%F%-%9%H(B, $BC14A;z(B
  (format "1:%s\t%s\t%s\t%s\t%s\n"
	  (format-time-string "%s")
	  word
	  pattern
	  (or context "")
	  (if prime-conv-exact-p "exact" "noexact"))
  )

(provide 'prime-log)

(and prime-log-mode
     (prime-log-mode-on))
