%define ruby_libdir %(ruby -rrbconfig -e 'puts Config::CONFIG["rubylibdir"]')
%define name    prime
%define version 0.8.5.2
%define release 1

Summary: PRIME - a Japanese PRedictive Input Method Editor
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
URL: http://taiyaki.org/prime
Source: http://taiyaki.org/prime/src/%{name}-%{version}.tar.gz
Group: Applications/System
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: ruby, ruby-sary, ruby-progressbar
BuildRequires: ruby

%description
PRIME predicts user's input words using the knowledge of natural
language and the history of user's operations, and reduces the
cost of typing by the user.  For example, if a user wants to input
"application" and types "ap" as the beginning characters of the word,
PRIME might predict some candidate words like "apple", "application",
"appointment", etc...  And then the user can input "application"
easily by selecting the word from the candidate words by PRIME.

%prep
%setup -q

%build
%configure
make

%install
rm -rf %{buildroot}
make DESTDIR=%{buildroot} rubydir=%{ruby_libdir} \
install install-etc

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_bindir}/*
%{_datadir}/prime
%{_libdir}/ruby/*/*
%{_libdir}/pkgconfig/*
%config(noreplace) %{_sysconfdir}/prime/Custom_prime.rb
%doc %{_docdir}/%{name}
%doc AUTHORS COPYING NEWS README ChangeLog doc

%changelog
* Fri Feb  6 2004 Masaki Yatsu <yatsu@digital-genes.com>
- add ruby-progressbar to the 'Requires'
- add lib/pkgconfig/prime.pc

* Tue Dec 30 2003 Masaki Yatsu <yatsu@digital-genes.com>
- add '(noreplace)' option to Custom_prime.rb

* Sun Dec 28 2003 Itou Hiroki <itouh(a)itpmail.itp.ne.jp>
- change 'make install' option
- add 'make install-etc'

* Tue May 13 2003 Masaki Yatsu <yatsu@digital-genes.com>
- first build
