#!/bin/sh
#
# Copyright (c) 2013  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$PRIPS" ] && PRIPS='./prips'

echo '1..15'

echo '# prips with no arguments should exit with code 1'
$PRIPS > /dev/null 2>&1
res="$?"
if [ "$res" = 1 ]; then echo 'ok 1'; else echo "not ok 1 exit code $res"; fi

echo '# print a single IP address'
v=`$PRIPS 127.0.0.3/32 2>/dev/null`
res="$?"
if [ "$res" = 0 ]; then echo 'ok 2'; else echo "not ok 2 exit code $res"; fi
if [ "$v" = '127.0.0.3' ]; then echo 'ok 3'; else echo "not ok 3 expected 127.0.0.3 got $v"; fi

echo '# print a single IP address, different delimiter'
v=`$PRIPS -d33 127.0.0.3/32 2>/dev/null`
res="$?"
if [ "$res" = 0 ]; then echo 'ok 4'; else echo "not ok 4 exit code $res"; fi
if [ "$v" = '127.0.0.3!' ]; then echo 'ok 5'; else echo "not ok 5 expected 127.0.0.3! got $v"; fi

echo '# test the widest prefix for a single IP address'
v=`$PRIPS -d33 127.0.0.3/31 2>/dev/null`
res="$?"
if [ "$res" = 1 ]; then echo 'ok 6'; else echo "not ok 6 exit code $res"; fi
if [ -z "$v" ]; then echo 'ok 7'; else echo "not ok 7 expected (empty) got $v"; fi

echo '# now the same, for a slightly different IP address'
v=`$PRIPS -d33 127.0.0.4/32 2>/dev/null`
exp='127.0.0.4!'
res="$?"
if [ "$res" = 0 ]; then echo 'ok 8'; else echo "not ok 8 exit code $res"; fi
if [ "$v" = "$exp" ]; then echo 'ok 9'; else echo "not ok 9 expected $exp got $v"; fi

v=`$PRIPS -d33 127.0.0.4/31 2>/dev/null`
exp='127.0.0.4!127.0.0.5!'
res="$?"
if [ "$res" = 0 ]; then echo 'ok 10'; else echo "not ok 10 exit code $res"; fi
if [ "$v" = "$exp" ]; then echo 'ok 11'; else echo "not ok 11 expected $exp got $v"; fi

v=`$PRIPS -d33 127.0.0.4/30 2>/dev/null`
exp='127.0.0.4!127.0.0.5!127.0.0.6!127.0.0.7!'
res="$?"
if [ "$res" = 0 ]; then echo 'ok 12'; else echo "not ok 12 exit code $res"; fi
if [ "$v" = "$exp" ]; then echo 'ok 13'; else echo "not ok 13 expected $exp got $v"; fi

v=`$PRIPS -d33 127.0.0.4/29 2>/dev/null`
res="$?"
if [ "$res" = 1 ]; then echo 'ok 14'; else echo "not ok 14 exit code $res"; fi
if [ -z "$v" ]; then echo 'ok 15'; else echo "not ok 15 expected (empty) got $v"; fi
