/*
 * prismstumbler wireless lan analyzing tool
 *
 * Copyright (C) 2000 and created by Jan Fernquist  <Jan.B.Fernquist@telia.com>
 * Copyright (C) 2004 Florian Boor <florian.boor@kernelconcepts.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * GTK+ frontend, help window
 *
 */
 
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libintl.h>

#include "helpwindow.h"

#define _(x) gettext(x)

extern GtkWidget *fMain;

#define HELPFILE PREFIX "/share/doc/prismstumbler/help.txt"


void
ps_do_help(void)
{
	GtkWidget *dialog, *sw;
	GtkWidget *textview;
	GtkTextBuffer *buffer;
	GError *error = NULL;
	gsize len;
	char *helptext = NULL;
	
	g_file_get_contents(HELPFILE,&helptext,&len,&error);
	
	if ((helptext == NULL) || (!strlen(helptext)))
	{
		helptext = g_strdup_printf("%s 	%s.",
			_("Help file not found, please install it to"), HELPFILE);
		len = strlen(helptext);
	}
	dialog = gtk_dialog_new_with_buttons(_("Help"),GTK_WINDOW(fMain),
	           GTK_DIALOG_DESTROY_WITH_PARENT,
	           GTK_STOCK_OK,
	           GTK_RESPONSE_ACCEPT,
	           NULL);
	sw = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	buffer = gtk_text_buffer_new(NULL);
	gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(buffer),helptext,len);
	textview = gtk_text_view_new_with_buffer(buffer);
	gtk_text_view_set_editable(GTK_TEXT_VIEW(textview),FALSE);
	gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textview),GTK_WRAP_WORD);
	gtk_container_add(GTK_CONTAINER(sw),textview);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),sw,TRUE,TRUE,0);
	gtk_widget_set_size_request(textview,220,250);

	g_free(helptext);
	gtk_widget_show_all(sw);
	gtk_dialog_run(GTK_DIALOG(dialog));
	gtk_widget_destroy(dialog);
}
