/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.MappingProcessor;

class StackTraceItem
implements MappingProcessor {
    private boolean verbose;
    public String prefix;
    public String obfuscatedClassName;
    public String obfuscatedMethodName;
    public String sourceFile;
    public int lineNumber;
    public String suffix;
    public String originalClassName;
    public List originalMethodNames;

    public StackTraceItem(boolean bl) {
        this.verbose = bl;
    }

    public void parse(String string) throws IOException {
        if (!this.parseAtLine(string) && !this.parseExceptionInThreadLine(string)) {
            this.parseAnyLine(string);
        }
    }

    private boolean parseAtLine(String string) {
        if (!string.startsWith("at ")) {
            return false;
        }
        int n = string.indexOf(40, 3);
        if (n < 0) {
            return false;
        }
        int n2 = string.indexOf(58, n + 1);
        int n3 = string.indexOf(41, Math.max(n, n2) + 1);
        if (n3 < 0) {
            return false;
        }
        int n4 = string.lastIndexOf(46, n - 1);
        if (n4 < 0) {
            return false;
        }
        this.prefix = "        at ";
        this.obfuscatedClassName = string.substring(3, n4).trim();
        this.obfuscatedMethodName = string.substring(n4 + 1, n).trim();
        this.sourceFile = string.substring(n + 1, n2 < 0 ? n3 : n2).trim();
        this.lineNumber = n2 < 0 ? 0 : Integer.parseInt(string.substring(n2 + 1, n3).trim());
        return true;
    }

    private boolean parseExceptionInThreadLine(String string) {
        int n;
        if (string.startsWith("Exception in thread \"")) {
            n = string.indexOf(34, 21);
            if (n < 0) {
                return false;
            }
            this.prefix = string.substring(0, n + 1) + " ";
            string = string.substring(n + 1).trim();
        }
        if ((n = string.indexOf(58)) < 0) {
            return false;
        }
        int n2 = string.lastIndexOf(32, n);
        this.prefix = string.substring(0, n2 + 1);
        this.obfuscatedClassName = string.substring(n2 + 1, n).trim();
        this.suffix = string.substring(n);
        return true;
    }

    private void parseAnyLine(String string) {
        this.prefix = string;
    }

    public void print() {
        String string;
        String string2 = this.originalClassName != null ? this.originalClassName : this.obfuscatedClassName;
        String string3 = this.originalMethodNames != null ? (String)this.originalMethodNames.get(0) : this.obfuscatedMethodName;
        String string4 = string = this.lineNumber != 0 ? this.sourceFile + ":" + this.lineNumber : this.sourceFile;
        if (this.prefix != null) {
            System.out.print(this.prefix);
        }
        if (string2 != null) {
            System.out.print(string2);
        }
        if (string3 != null) {
            System.out.print("." + string3 + "(" + string + ")");
            if (this.originalMethodNames != null) {
                for (int i = 1; i < this.originalMethodNames.size(); ++i) {
                    String string5 = (String)this.originalMethodNames.get(i);
                    System.out.println();
                    this.printSpaces(string2.length() + 12);
                    System.out.print(string5);
                }
            }
        }
        if (this.suffix != null) {
            System.out.print(this.suffix);
        }
        System.out.println();
    }

    private void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }

    public boolean processClassFileMapping(String string, String string2) {
        boolean bl = false;
        if (string2.equals(this.obfuscatedClassName)) {
            this.originalClassName = string;
            bl = true;
        }
        return bl;
    }

    public void processFieldMapping(String string, String string2, String string3, String string4) {
    }

    public void processMethodMapping(String string, int n, int n2, String string2, String string3, String string4) {
        if (string.equals(this.originalClassName) && string4.equals(this.obfuscatedMethodName) && (this.lineNumber == 0 || n == 0 || n2 == 0 || n <= this.lineNumber && n2 >= this.lineNumber)) {
            if (this.originalMethodNames == null) {
                this.originalMethodNames = new ArrayList();
            }
            if (n != 0 && n2 != 0 && this.lineNumber != 0) {
                this.obfuscatedMethodName = null;
                this.originalMethodNames.clear();
            }
            String string5 = this.verbose ? string2 + " " + string3 : string3.substring(0, string3.indexOf(40));
            this.originalMethodNames.add(string5);
        }
    }
}

