/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMemberInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.MethodInfoLinker;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.NameFactory;

public class MemberInfoObfuscator
implements MemberInfoVisitor {
    private boolean allowAggressiveOverloading;
    private NameFactory nameFactory;
    private Map descriptorMap;

    public MemberInfoObfuscator(boolean bl, NameFactory nameFactory, Map map) {
        this.allowAggressiveOverloading = bl;
        this.nameFactory = nameFactory;
        this.descriptorMap = map;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.visitMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        String string = programMethodInfo.getName(programClassFile);
        if (string.equals("<clinit>") || string.equals("<init>")) {
            return;
        }
        this.visitMemberInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    private void visitMemberInfo(ClassFile classFile, MemberInfo memberInfo) {
        String string = memberInfo.getName(classFile);
        String string2 = memberInfo.getDescriptor(classFile);
        if (!this.allowAggressiveOverloading) {
            string2 = string2.substring(0, string2.indexOf(41) + 1);
        }
        Map map = MemberInfoObfuscator.retrieveNameMap(this.descriptorMap, string2);
        String string3 = MemberInfoObfuscator.newMemberName(memberInfo);
        if (string3 == null) {
            this.nameFactory.reset();
            while (map.containsKey(string3 = this.nameFactory.nextName())) {
            }
            map.put(string3, string);
            MemberInfoObfuscator.setNewMemberName(memberInfo, string3);
        }
    }

    static Map retrieveNameMap(Map map, String string) {
        HashMap hashMap = (HashMap)map.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(string, hashMap);
        }
        return hashMap;
    }

    static void setFixedNewMemberName(MemberInfo memberInfo, String string) {
        VisitorAccepter visitorAccepter = MethodInfoLinker.lastVisitorAccepter(memberInfo);
        if (!(visitorAccepter instanceof LibraryMemberInfo) && !(visitorAccepter instanceof MyFixedName)) {
            visitorAccepter.setVisitorInfo(new MyFixedName(string));
        } else {
            visitorAccepter.setVisitorInfo(string);
        }
    }

    static void setNewMemberName(MemberInfo memberInfo, String string) {
        MethodInfoLinker.lastVisitorAccepter(memberInfo).setVisitorInfo(string);
    }

    static boolean hasFixedNewMemberName(MemberInfo memberInfo) {
        VisitorAccepter visitorAccepter = MethodInfoLinker.lastVisitorAccepter(memberInfo);
        return visitorAccepter instanceof LibraryMemberInfo || visitorAccepter instanceof MyFixedName;
    }

    static String newMemberName(MemberInfo memberInfo) {
        return (String)MethodInfoLinker.lastVisitorAccepter(memberInfo).getVisitorInfo();
    }

    private static class MyFixedName
    implements VisitorAccepter {
        private String newName;

        public MyFixedName(String string) {
            this.newName = string;
        }

        public Object getVisitorInfo() {
            return this.newName;
        }

        public void setVisitorInfo(Object object) {
            this.newName = (String)object;
        }
    }
}

