/*
   GNUstep ProjectCenter - http://www.gnustep.org

   Copyright (C) 2001-2004 Free Software Foundation

   Authors: Philippe C.D. Robert
            Serg Stoyan
	    
   Description: Creates new project of the type Tool!

   This file is part of GNUstep.

   This application is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <ProjectCenter/PCFileCreator.h>
#include <ProjectCenter/PCMakefileFactory.h>

#include "PCToolProj.h"
#include "PCToolProject.h"

@implementation PCToolProj

static PCToolProj *_creator = nil;

//----------------------------------------------------------------------------
// ProjectType
//----------------------------------------------------------------------------

+ (id)sharedCreator
{
  if (!_creator)
    {
      _creator = [[[self class] alloc] init];
    }

  return _creator;
}

- (Class)projectClass
{
  return [PCToolProject class];
}

- (NSString *)projectTypeName
{
  return @"Tool";
}

- (PCProject *)createProjectAt:(NSString *)path
{
  PCToolProject *project = nil;
  NSFileManager *fm = [NSFileManager defaultManager];

  NSAssert(path,@"No valid project path provided!");

  if ([fm createDirectoryAtPath:path attributes:nil])
    {
      NSString            *_file = nil;
      NSString            *_2file = nil;
//      NSString            *_lresourcePath;
      NSString            *_resourcePath;
      NSMutableDictionary *projectDict = nil;
      NSBundle            *projectBundle = nil;
      NSString            *projectName = nil;
      NSMutableDictionary *infoDict = nil;
      PCFileCreator       *fc = [PCFileCreator sharedCreator];

      project = [[[PCToolProject alloc] init] autorelease];
      projectBundle = [NSBundle bundleForClass:[self class]];

      _file = [projectBundle pathForResource:@"PC" ofType:@"project"];
      projectDict = [NSMutableDictionary dictionaryWithContentsOfFile:_file];

      // Customise the project
      projectName = [path lastPathComponent];
      if ([[projectName pathExtension] isEqualToString:@"subproj"])
	{
	  projectName = [projectName stringByDeletingPathExtension];
	}
      [projectDict setObject:projectName forKey:PCProjectName];
      [projectDict setObject:[self projectTypeName] forKey:PCProjectType];
      [projectDict setObject:[[NSCalendarDate date] description]
	              forKey:PCCreationDate];
      [projectDict setObject:NSFullUserName() forKey:PCProjectCreator];
      [projectDict setObject:NSFullUserName() forKey:PCProjectMaintainer];
      // The path cannot be in the PC.project file!
      [project setProjectPath:path];
      [project setProjectName:projectName];

      // Copy the project files to the provided path
      _file = [projectBundle pathForResource:@"main" ofType:@"m"];
      _2file = [path stringByAppendingPathComponent:@"main.m"];
      [fm copyPath:_file toPath:_2file handler:nil];
      [fc replaceTagsInFileAtPath:_2file withProject:project];

      // GNUmakefile.postamble
      [[PCMakefileFactory sharedFactory] createPostambleForProject:project];

      // Resources
/*      _lresourcePath = [path stringByAppendingPathComponent:@"English.lproj"];
      [fm createDirectoryAtPath:_resourcePath attributes:nil];*/
      _resourcePath = [path stringByAppendingPathComponent:@"Resources"];
      [fm createDirectoryAtPath:_resourcePath attributes:nil];

      // Create the Info-gnustep.plist
      infoDict = [NSDictionary dictionaryWithObjectsAndKeys:
        @"Generated by ProjectCenter, do not edit", @"!",
        projectName, @"ToolName",
        @"", @"ToolDescription",
        @"", @"ToolIcon",
        @"0.1", @"ToolRelease",
        @"0.1", @"FullVersionID",
        [NSArray array], @"Authors",
        @"", @"URL",
        @"Copyright (C) 200x by ...", @"Copyright",
        @"Released under...", @"CopyrightDescription",
        nil];

      _2file = [_resourcePath 
	stringByAppendingPathComponent:@"Info-gnustep.plist"];
      [infoDict writeToFile:_2file atomically:YES];

      [projectDict
        setObject:[NSArray arrayWithObjects:@"Info-gnustep.plist",nil]
           forKey:PCOtherResources];

      [project assignInfoDict:(NSMutableDictionary *)infoDict];

      // Set the new dictionary - this causes the GNUmakefile to be written
      if(![project assignProjectDict:projectDict])
	{
	  NSRunAlertPanel(@"Attention!",
			  @"Could not load %@!",
			  @"OK",nil,nil,path);
	  return nil;
	}

      // Save the project to disc
      [project save];
    }

  return project;
}

- (PCProject *)openProjectAt:(NSString *)path
{
  NSDictionary  *dict = [NSDictionary dictionaryWithContentsOfFile:path];
  NSString      *pPath = [path stringByDeletingLastPathComponent];
  PCToolProject *project = nil;

  project = [[[PCToolProject alloc] 
    initWithProjectDictionary:dict 
                         path:pPath] autorelease];

  [project loadInfoFileAtPath:[path stringByDeletingLastPathComponent]];

  return project;
}

@end
