/******************************************************************************
* Copyright (C) 2009 - Ikaro Games   www.ikarogames.com                       *
*                                                                             *
* This program is free software; you can redistribute it and/or               *
* modify it under the terms of the GNU General Public License                 *
* as published by the Free Software Foundation; either version 2              *
* of the License, or (at your option) any later version.                      *
*                                                                             *
* This program is distributed in the hope that it will be useful,             *
* but WITHOUT ANY WARRANTY; without even the implied warranty of              *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
* GNU General Public License for more details.                                *
*                                                                             *
* You should have received a copy of the GNU General Public License           *
* along with this program; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *
*                                                                             *
*                                                                             *
*       generated by dia/DAOcodegen.py                                        *
*       Version: 1.23                                                         *
******************************************************************************/

#include <stdlib.h>
#include <string.h>

#include "CPfCompetitionsBySeasonDAOSQLiteEntity.h"
#include "../../../../../exceptions/PFException.h"
#include "../../../../../utils/CLog.h"

CPfCompetitionsBySeasonDAOSQLiteEntity::CPfCompetitionsBySeasonDAOSQLiteEntity(sqlite3 *database)
{
    m_database = database;
}

CPfCompetitionsBySeasonDAOSQLiteEntity::~CPfCompetitionsBySeasonDAOSQLiteEntity()
{
}

void CPfCompetitionsBySeasonDAOSQLiteEntity::setSQLite(sqlite3 *database)
{
    m_database = database;
}

bool CPfCompetitionsBySeasonDAOSQLiteEntity::deleteReg(CPfCompetitionsBySeason *reg)
{
    std::string sql("DELETE FROM PF_COMPETITIONS_BY_SEASON WHERE X_COMPETITION_BY_SEASON=");
    sql += "'"+reg->getXCompetitionBySeason_str()+"'";
    return exec(sql);
}

bool CPfCompetitionsBySeasonDAOSQLiteEntity::insertReg(CPfCompetitionsBySeason *reg)
{
    std::string sql("INSERT INTO PF_COMPETITIONS_BY_SEASON (X_FK_SEASON,D_END_COMPETITION,X_FK_COMPETITION,D_BEGIN_COMPETITION) VALUES (");
    sql += (reg->getXFkSeason_str()=="")?"NULL":"'"+reg->getXFkSeason_str()+"'";
    sql += (reg->getDEndCompetition_str()=="")?",NULL":",'"+reg->getDEndCompetition_str()+"'";
    sql += (reg->getXFkCompetition_str()=="")?",NULL":",'"+reg->getXFkCompetition_str()+"'";
    sql += (reg->getDBeginCompetition_str()=="")?",NULL":",'"+reg->getDBeginCompetition_str()+"'";
    sql += ")";
    if( exec(sql) ){
        reg->setXCompetitionBySeason(sqlite3_last_insert_rowid(m_database));
        return true;
    }else{
        return false;
    }
}

bool CPfCompetitionsBySeasonDAOSQLiteEntity::updateReg(CPfCompetitionsBySeason *reg)
{
    std::string sql("UPDATE PF_COMPETITIONS_BY_SEASON SET ");
    sql += (reg->getXFkSeason_str()=="")?" X_FK_SEASON=NULL":" X_FK_SEASON='"+reg->getXFkSeason_str()+"'";
    sql += (reg->getXCompetitionBySeason_str()=="")?",X_COMPETITION_BY_SEASON=NULL":",X_COMPETITION_BY_SEASON='"+reg->getXCompetitionBySeason_str()+"'";
    sql += (reg->getDEndCompetition_str()=="")?",D_END_COMPETITION=NULL":",D_END_COMPETITION='"+reg->getDEndCompetition_str()+"'";
    sql += (reg->getXFkCompetition_str()=="")?",X_FK_COMPETITION=NULL":",X_FK_COMPETITION='"+reg->getXFkCompetition_str()+"'";
    sql += (reg->getDBeginCompetition_str()=="")?",D_BEGIN_COMPETITION=NULL":",D_BEGIN_COMPETITION='"+reg->getDBeginCompetition_str()+"'";
    sql += " WHERE X_COMPETITION_BY_SEASON='"+reg->getXCompetitionBySeason_str()+"'";
    return exec(sql);
}

void CPfCompetitionsBySeasonDAOSQLiteEntity::freeVector(std::vector<CPfCompetitionsBySeason*>* vector )
{
    std::vector<CPfCompetitionsBySeason*>::iterator it;
    for( it=vector->begin(); it!=vector->end(); it++ ){
        delete (*it);
        (*it) = NULL;
    }
    delete vector;
}

CPfCompetitionsBySeason* CPfCompetitionsBySeasonDAOSQLiteEntity::loadRegister(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    CPfCompetitionsBySeason *destiny = new CPfCompetitionsBySeason();
    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);
    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return destiny;
}

std::vector<CPfCompetitionsBySeason*> * CPfCompetitionsBySeasonDAOSQLiteEntity::loadVector(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    std::vector<CPfCompetitionsBySeason*> *container = new std::vector<CPfCompetitionsBySeason*>;
    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return container;
}

bool CPfCompetitionsBySeasonDAOSQLiteEntity::exec(const std::string &sql)
{
    if( m_database==NULL ){
        throw PFEXCEPTION("No database connection.");
    }

    char *msgError = NULL;
    bool correct = true;
    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);
    if( result!=SQLITE_OK ){
        LOG_ERROR("Error in SQL: \"%s\" --> \"%s\"", sql.c_str(), msgError);
        correct = false;
    }
    if( msgError!=NULL ){ 
        sqlite3_free(msgError);
    }
    return correct;
}

int CPfCompetitionsBySeasonDAOSQLiteEntity::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        CPfCompetitionsBySeason *destiny = (CPfCompetitionsBySeason*)object;
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_SEASON")==0 ){
                destiny->setXFkSeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_COMPETITION_BY_SEASON")==0 ){
                destiny->setXCompetitionBySeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_END_COMPETITION")==0 ){
                destiny->setDEndCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_COMPETITION")==0 ){
                destiny->setXFkCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_BEGIN_COMPETITION")==0 ){
                destiny->setDBeginCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
    }
    return -1; // Abort, don't load more rows
}

int CPfCompetitionsBySeasonDAOSQLiteEntity::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)
{
    if( object!=NULL ){
        std::vector<CPfCompetitionsBySeason*> *container = (std::vector<CPfCompetitionsBySeason*> *)object;
        CPfCompetitionsBySeason *destiny = new CPfCompetitionsBySeason();
        for( int i=0; i<nColumns; i++ ){
            if( strcmp(sColumn[i], "X_FK_SEASON")==0 ){
                destiny->setXFkSeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_COMPETITION_BY_SEASON")==0 ){
                destiny->setXCompetitionBySeason_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_END_COMPETITION")==0 ){
                destiny->setDEndCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "X_FK_COMPETITION")==0 ){
                destiny->setXFkCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }else if( strcmp(sColumn[i], "D_BEGIN_COMPETITION")==0 ){
                destiny->setDBeginCompetition_str((vColumn[i]==NULL)?"":vColumn[i]);
            }
        }
        container->push_back(destiny);
    }
    return 0; // All OK
}

