# -*- coding: iso-8859-15 -*-
#
# PyDia C++ DAO Code Generation from UML Diagram
# Copyright (c) 2008-2010 Ikaro Games <www.ikarogames.com>
#
# Version: 1.23
#
# Based on PyDia Code Generation from UML Diagram
# Copyright (c) 2005  Hans Breuer <hans@breuer.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


import os, sys, dia
from string import Template

##################################################################################################
# UtilRenderer ###################################################################################
##################################################################################################
class UtilRenderer :
  def license(self) :
    string = "/******************************************************************************\n"+\
             "* Copyright (C) 2010 - Ikaro Games   www.ikarogames.com                       *\n"+\
             "*                                                                             *\n"+\
             "* This program is free software; you can redistribute it and/or               *\n"+\
             "* modify it under the terms of the GNU General Public License                 *\n"+\
             "* as published by the Free Software Foundation; either version 2              *\n"+\
             "* of the License, or (at your option) any later version.                      *\n"+\
             "*                                                                             *\n"+\
             "* This program is distributed in the hope that it will be useful,             *\n"+\
             "* but WITHOUT ANY WARRANTY; without even the implied warranty of              *\n"+\
             "* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *\n"+\
             "* GNU General Public License for more details.                                *\n"+\
             "*                                                                             *\n"+\
             "* You should have received a copy of the GNU General Public License           *\n"+\
             "* along with this program; if not, write to the Free Software                 *\n"+\
             "* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. *\n"+\
             "*                                                                             *\n"+\
             "*                                                                             *\n"+\
             "*       generated by dia/DAOcodegen.py                                        *\n"+\
             "*       Version: 1.23                                                         *\n"+\
             "******************************************************************************/\n\n"
    return string

  def interfaceName(self, cadena) :
    cad = cadena
    cad = cad.lower()
    cad = cad.replace("_", " ")
    cad = cad.title()
    cad = cad.replace(" ", "")
    cad = "I" + cad
    return cad

  def className(self, cadena) :
    cad = cadena
    cad = cad.lower()
    cad = cad.replace("_", " ")
    cad = cad.title()
    cad = cad.replace(" ", "")
    cad = "C" + cad
    return cad

  def attributeName(self, cadena) :
    cad = cadena
    cad = cad.lower()
    cad = cad.replace("_", " ")
    cad = cad.title()
    cad = cad.replace(" ", "")
    return cad

  def defineH(self, cadena) :
    cad = cadena
    cad = cad.upper()
    cad = "#ifndef "+cad+"_H_\n"+\
          "#define "+cad+"_H_\n\n"
    return cad

  def endDefineH(self, cadena) :
    cad = cadena
    cad = cad.upper()
    cad = "#endif /*"+cad+"_H_*/\n"
    return cad

  def primaryKey(self, klass) :
    pk = ""
    for a in klass.attributes.keys() :
      if a[:2]=="X_" and a[:4]!="X_FK" :
        pk = a
    return pk

  def thereIsDateAttrib(self, klass) :
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="DATE" :
        return 1
    return 0


##################################################################################################
# IDAOFactoryRenderer ############################################################################
##################################################################################################
class IDAOFactoryRenderer(UtilRenderer) :
  def includes(self, klasses) :
    inc = ""
    for klass in klasses.keys() :
      inc = inc+"#include \"../"+self.interfaceName(klass)+"DAO.h\"\n"
    inc = inc+"\n"
    return inc

  def methods(self, klasses) :
    meth = ""
    for klass in klasses.keys() :
      meth = meth+"    virtual "+self.interfaceName(klass)+"DAO* get"+self.interfaceName(klass)+"DAO() =0;\n"
    meth = meth+"\n"
    return meth

  def render(self, path, klasses) :
    file = open(os.path.join(path, "db/dao/factory/IDAOFactory.h"), "w")
    file.write(self.license())
    file.write(self.defineH("IDAOFactory"))
    file.write(self.includes(klasses))
    file.write("class IDAOFactory\n")
    file.write("{\n")
    file.write("public:\n")
    file.write("    IDAOFactory(){}\n")
    file.write("    virtual ~IDAOFactory(){}\n")
    file.write("\n")
    file.write("    virtual bool executeScript(const std::string &script) =0;\n")
    file.write("    virtual bool executeScriptFile(const char *scriptFile) =0;\n")
    file.write("\n")
    file.write("    virtual bool beginTransaction() =0;\n")
    file.write("    virtual bool commit() =0;\n")
    file.write("    virtual bool rollback() =0;\n")
    file.write("\n")
    file.write("    virtual void save() =0;\n")
    file.write("\n")
    file.write(self.methods(klasses))
    file.write("};\n")
    file.write(self.endDefineH("IDAOFactory"))
    file.close()


##################################################################################################
# IClassDAORenderer ##############################################################################
##################################################################################################
class IClassDAORenderer(UtilRenderer) :
  def render(self, path, klass) :
    cClass    = self.className(klass.name)
    iClassDAO = self.interfaceName(klass.name)+"DAO"
    file = open(os.path.join(path, "db/dao/"+iClassDAO+".h"), "w")
    file.write(self.license())
    file.write(self.defineH(iClassDAO))
    file.write("#include <string>\n")
    file.write("#include <vector>\n")
    file.write("\n")
    file.write("#include \"../bean/"+cClass+".h\"\n")
    file.write("\n")
    file.write("class "+iClassDAO+"\n")
    file.write("{\n")
    file.write("public:\n")
    file.write("    "+iClassDAO+"(){}\n")
    file.write("    virtual ~"+iClassDAO+"(){}\n")
    file.write("\n")
    if klass.stereotype!="VIEW" :
      file.write("    virtual bool deleteReg("+cClass+" *reg) =0;\n")
      file.write("    virtual bool insertReg("+cClass+" *reg) =0;\n")
      file.write("    virtual bool updateReg("+cClass+" *reg) =0;\n")
      file.write("\n")
    file.write("    virtual void freeVector(std::vector<"+cClass+"*>* vector) =0;\n")
    file.write("\n")
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if a[:2]=="X_" :
        if t=="TEXT" :
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+") =0;\n")
        elif t=="INTEGER" :
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(int "+self.attributeName(a)+") =0;\n")
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+") =0;\n")
        elif t=="DOUBLE" :
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(double "+self.attributeName(a)+") =0;\n")
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+") =0;\n")
    file.write("\n")
    file.write("};\n")
    file.write(self.endDefineH(iClassDAO))
    file.close()


##################################################################################################
# CBeanClassRenderer #############################################################################
##################################################################################################
class CBeanClassRenderer(UtilRenderer) :
  def renderGettersH(self, klass) :
    getters = ""
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="TEXT" :
        getters += "    const std::string& get"+self.attributeName(a)+"() const;\n"
        getters += "    const std::string& get"+self.attributeName(a)+"_str() const;\n"
      elif t=="INTEGER" :
        getters += "    int get"+self.attributeName(a)+"() const;\n"
        getters += "    const std::string& get"+self.attributeName(a)+"_str() const;\n"
      elif t=="DOUBLE" :
        getters += "    double get"+self.attributeName(a)+"() const;\n"
        getters += "    const std::string& get"+self.attributeName(a)+"_str() const;\n"
      elif t=="DATE" :
        getters += "    CDate get"+self.attributeName(a)+"() const;\n"
        getters += "    const std::string& get"+self.attributeName(a)+"_str() const;\n"
      elif t=="BOOLEAN" :
        getters += "    bool get"+self.attributeName(a)+"() const;\n"
        getters += "    const std::string& get"+self.attributeName(a)+"_str() const;\n"
    return getters

  def renderSettersH(self, klass) :
    setters = ""
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="TEXT" :
        setters += "    void set"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+");\n"
        setters += "    void set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+");\n"
      elif t=="INTEGER" :
        setters += "    void set"+self.attributeName(a)+"(int "+self.attributeName(a)+");\n"
        setters += "    void set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+");\n"
      elif t=="DOUBLE" :
        setters += "    void set"+self.attributeName(a)+"(double "+self.attributeName(a)+");\n"
        setters += "    void set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+");\n"
      elif t=="DATE" :
        setters += "    void set"+self.attributeName(a)+"(const CDate &"+self.attributeName(a)+");\n"
        setters += "    void set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+");\n"
      elif t=="BOOLEAN" :
        setters += "    void set"+self.attributeName(a)+"(bool "+self.attributeName(a)+");\n"
        setters += "    void set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+");\n"
    return setters

  def renderAttribsH(self, klass) :
    attribs = ""
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="TEXT" :
        attribs += "    std::string m_"+self.attributeName(a)+";\n"
      elif t=="INTEGER" :
        attribs += "    std::string m_"+self.attributeName(a)+";\n"
      elif t=="DOUBLE" :
        attribs += "    std::string m_"+self.attributeName(a)+";\n"
      elif t=="DATE" :
        attribs += "    std::string m_"+self.attributeName(a)+";\n"
      elif t=="BOOLEAN" :
        attribs += "    std::string m_"+self.attributeName(a)+";\n"
    return attribs

  def renderH(self, path, klass) :
    cClass = self.className(klass.name)
    file = open(os.path.join(path, "db/bean/"+cClass+".h"), "w")
    file.write(self.license())
    file.write(self.defineH(cClass))
    file.write("#include <string>\n")
    file.write("\n")
    if self.thereIsDateAttrib(klass)!=0 :
      file.write("#include \"../../../utils/CDate.h\"\n")
      file.write("\n")
    file.write("class "+cClass+"\n")
    file.write("{\n")
    file.write("public:\n")
    file.write("    "+cClass+"();\n")
    file.write("    "+cClass+"(const "+cClass+" &obj);\n")
    file.write("    virtual ~"+cClass+"();\n")
    file.write("\n")
    file.write(self.renderGettersH(klass))
    file.write("\n")
    file.write(self.renderSettersH(klass))
    file.write("\n")
    file.write("private:\n")
    file.write(self.renderAttribsH(klass))
    file.write("\n")
    file.write("};\n")
    file.write(self.endDefineH(cClass))
    file.close()

  def renderConstructorCPP(self, klass) :
    cClass = self.className(klass.name)
    constructor  = cClass+"::"+cClass+"()\n"
    constructor += "{\n"
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="TEXT" :
        constructor += "    m_"+self.attributeName(a)+" = \"\";\n"
      elif t=="INTEGER" :
        constructor += "    m_"+self.attributeName(a)+" = \"0\";\n"
      elif t=="DOUBLE" :
        constructor += "    m_"+self.attributeName(a)+" = \"0.0\";\n"
      elif t=="DATE" :
        constructor += "    m_"+self.attributeName(a)+" = \"\";\n"
      elif t=="BOOLEAN" :
        constructor += "    m_"+self.attributeName(a)+" = \"N\";\n"
    constructor += "}\n\n"
    constructor += cClass+"::"+cClass+"(const "+cClass+" &obj)\n"
    constructor += "{\n"
    for a in klass.attributes.keys() :
      constructor += "    m_"+self.attributeName(a)+" = obj.m_"+self.attributeName(a)+";\n"
    constructor += "}\n\n"
    return constructor

  def renderDestructorCPP(self, klass) :
    cClass = self.className(klass.name)
    destructor  = cClass+"::~"+cClass+"()\n"
    destructor += "{\n"
    destructor += "}\n\n"
    return destructor

  def renderGettersCPP(self, klass) :
    getters = ""
    cClass  = self.className(klass.name)
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="TEXT" :
        getters += "const std::string& "+cClass+"::get"+self.attributeName(a)+"() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
        getters += "const std::string& "+cClass+"::get"+self.attributeName(a)+"_str() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
      elif t=="INTEGER" :
        getters += "int "+cClass+"::get"+self.attributeName(a)+"() const\n"
        getters += "{\n"
        getters += "    if( m_"+self.attributeName(a)+"==\"\" ){\n"
        getters += "        return 0;\n"
        getters += "    }else{\n"
        getters += "        return atoi(m_"+self.attributeName(a)+".c_str());\n"
        getters += "    }\n"
        getters += "}\n\n"
        getters += "const std::string& "+cClass+"::get"+self.attributeName(a)+"_str() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
      elif t=="DOUBLE" :
        getters += "double "+cClass+"::get"+self.attributeName(a)+"() const\n"
        getters += "{\n"
        getters += "    if( m_"+self.attributeName(a)+"==\"\" ){\n"
        getters += "        return 0.0;\n"
        getters += "    }else{\n"
        getters += "        return atof(m_"+self.attributeName(a)+".c_str());\n"
        getters += "    }\n"
        getters += "}\n\n"
        getters += "const std::string& "+cClass+"::get"+self.attributeName(a)+"_str() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
      elif t=="DATE" :
        getters += "CDate "+cClass+"::get"+self.attributeName(a)+"() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
        getters += "const std::string& "+cClass+"::get"+self.attributeName(a)+"_str() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
      elif t=="BOOLEAN" :
        getters += "bool "+cClass+"::get"+self.attributeName(a)+"() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+"!=\"\" && m_"+self.attributeName(a)+"!=\"N\";\n"
        getters += "}\n\n"
        getters += "const std::string& "+cClass+"::get"+self.attributeName(a)+"_str() const\n"
        getters += "{\n"
        getters += "    return m_"+self.attributeName(a)+";\n"
        getters += "}\n\n"
    return getters

  def renderSettersCPP(self, klass) :
    setters = ""
    cClass  = self.className(klass.name)
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if t=="TEXT" :
        setters += "void "+cClass+"::set"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+";\n"
        setters += "}\n\n"
        setters += "void "+cClass+"::set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+";\n"
        setters += "}\n\n"
      elif t=="INTEGER" :
        setters += "void "+cClass+"::set"+self.attributeName(a)+"(int "+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    std::ostringstream stream;\n"
        setters += "    stream << "+self.attributeName(a)+";\n"
        setters += "    m_"+self.attributeName(a)+" = stream.str();\n"
        setters += "}\n\n"
        setters += "void "+cClass+"::set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+";\n"
        setters += "}\n\n"
      elif t=="DOUBLE" :
        setters += "void "+cClass+"::set"+self.attributeName(a)+"(double "+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    std::ostringstream stream;\n"
        setters += "    stream << "+self.attributeName(a)+";\n"
        setters += "    m_"+self.attributeName(a)+" = stream.str();\n"
        setters += "}\n\n"
        setters += "void "+cClass+"::set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+";\n"
        setters += "}\n\n"
      elif t=="DATE" :
        setters += "void "+cClass+"::set"+self.attributeName(a)+"(const CDate &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+".getTimestamp();\n"
        setters += "}\n\n"
        setters += "void "+cClass+"::set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+";\n"
        setters += "}\n\n"
      elif t=="BOOLEAN" :
        setters += "void "+cClass+"::set"+self.attributeName(a)+"(bool "+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    if( "+self.attributeName(a)+" ){\n"
        setters += "        m_"+self.attributeName(a)+" = \"Y\";\n"
        setters += "    }else{\n"
        setters += "        m_"+self.attributeName(a)+" = \"N\";\n"
        setters += "    }\n"
        setters += "}\n\n"
        setters += "void "+cClass+"::set"+self.attributeName(a)+"_str(const std::string &"+self.attributeName(a)+")\n"
        setters += "{\n"
        setters += "    m_"+self.attributeName(a)+" = "+self.attributeName(a)+";\n"
        setters += "}\n\n"
    return setters

  def renderCPP(self, path, klass) :
    cClass = self.className(klass.name)
    file = open(os.path.join(path, "db/bean/"+cClass+".cpp"), "w")
    file.write(self.license())
    file.write("#include <iostream>\n")
    file.write("#include <sstream>\n")
    file.write("#include <stdlib.h>\n")
    file.write("\n")
    file.write("#include \""+cClass+".h\"\n")
    file.write("\n")
    file.write(self.renderConstructorCPP(klass))
    file.write(self.renderDestructorCPP(klass))
    file.write(self.renderGettersCPP(klass))
    file.write(self.renderSettersCPP(klass))
    file.close()

  def render(self, path, klass) :
    self.renderH(path, klass)
    self.renderCPP(path, klass)


##################################################################################################
# CDAOFactorySQLiteRenderer ######################################################################
##################################################################################################
class CDAOFactorySQLiteRenderer(UtilRenderer) :
  def includesDAO(self, klasses) :
    inc = ""
    for klass in klasses.keys() :
      inc += "#include \"../../../dao/"+self.interfaceName(klass)+"DAO.h\"\n"
    inc += "\n"
    for klass in klasses.keys() :
      inc += "#include \"../"+self.className(klass)+"DAOSQLite.h\"\n"
    inc += "\n"
    return inc

  def methodsH(self, klasses) :
    meth = ""
    for klass in klasses.keys() :
      meth += "    virtual "+self.interfaceName(klass)+"DAO* get"+self.interfaceName(klass)+"DAO();\n"
    meth += "\n"
    return meth

  def renderAttribsH(self, klasses) :
    attribs = ""
    for klass in klasses.keys() :
      attribs += "    "+self.className(klass)+"DAOSQLite"+" *m_"+self.attributeName(klass)+"DAOSQLite"+";\n"
    return attribs

  def renderH(self, path, klasses) :
    file = open(os.path.join(path, "db/sqlite/dao/factory/CDAOFactorySQLite.h"), "w")
    file.write(self.license())
    file.write(self.defineH("CDAOFactorySQLite"))
    file.write("#include <sqlite3.h>\n")
    file.write("#include <string>\n")
    file.write("\n")
    file.write("#include \"../../../dao/factory/IDAOFactory.h\"\n")
    file.write("\n")
    file.write(self.includesDAO(klasses))
    file.write("class CDAOFactorySQLite : public IDAOFactory\n")
    file.write("{\n")
    file.write("public:\n")
    file.write("    CDAOFactorySQLite(const std::string &filepath);\n")
    file.write("    virtual ~CDAOFactorySQLite();\n")
    file.write("\n")
    file.write("    virtual bool executeScript(const std::string &script);\n")
    file.write("    virtual bool executeScriptFile(const char *scriptFile);\n")
    file.write("\n")
    file.write("    virtual bool beginTransaction();\n")
    file.write("    virtual bool commit();\n")
    file.write("    virtual bool rollback();\n")
    file.write("\n")
    file.write("    virtual void save();\n")
    file.write("\n")
    file.write(self.methodsH(klasses))
    file.write("\n")
    file.write("private:\n")
    file.write("    void copyFile(const std::string &origin, const std::string &destination);\n")
    file.write("\n")
    file.write("private:\n")
    file.write("    sqlite3     *m_database;\n")
    file.write("    std::string m_filepath;\n")
    file.write("    std::string m_filepath_tmp;\n")
    file.write("\n")
    file.write(self.renderAttribsH(klasses))
    file.write("\n")
    file.write("};\n")
    file.write(self.endDefineH("CDAOFactorySQLite"))
    file.close()

  def renderConstructorCPP(self, klasses) :
    constructor  = "CDAOFactorySQLite::CDAOFactorySQLite(const std::string &filepath)\n"
    constructor += "{\n"
    constructor += "    m_filepath      = filepath;\n"
    constructor += "    m_filepath_tmp  = filepath;\n"
    constructor += "    m_filepath_tmp += \".tmp\";\n"
    constructor += "\n"
    constructor += "    copyFile(m_filepath, m_filepath_tmp);\n"
    constructor += "    if( sqlite3_open(m_filepath_tmp.c_str(), &m_database )!=SQLITE_OK ){\n"
    constructor += "        sqlite3_close(m_database);\n"
    constructor += "        m_database = NULL;\n"
    constructor += "        throw PFEXCEPTION(\"Can't open database file: '%s' --> '%s'\", m_filepath_tmp.c_str(), sqlite3_errmsg(m_database));\n"
    constructor += "    }\n"
    constructor += "\n"
    for klass in klasses.keys() :
      constructor += "    m_"+self.attributeName(klass)+"DAOSQLite = new "+self.className(klass)+"DAOSQLite(m_database);\n"
    constructor += "\n"
    constructor += "    LOG_DEBUG(\"[CDAOFactorySQLite::CDAOFactorySQLite] SQLite Database open: '%s'\", m_filepath_tmp.c_str());\n"
    constructor += "}\n\n"
    return constructor

  def renderDestructorCPP(self, klasses) :
    destructor  = "CDAOFactorySQLite::~CDAOFactorySQLite()\n"
    destructor += "{\n"
    for klass in klasses.keys() :
      destructor += "    delete m_"+self.attributeName(klass)+"DAOSQLite;\n"
    destructor += "\n"
    destructor += "    sqlite3_close(m_database);\n"
    destructor += "    remove(m_filepath_tmp.c_str());\n"
    destructor += "    LOG_DEBUG(\"[CDAOFactorySQLite::~CDAOFactorySQLite] SQLite Database closed: '%s'\", m_filepath_tmp.c_str());\n"
    destructor += "}\n\n"
    return destructor

  def renderExecuteScript(self) :
    execute  = "bool CDAOFactorySQLite::executeScript(const std::string &script)\n"
    execute += "{\n"
    execute += "    if( m_database==NULL ){\n"
    execute += "        throw PFEXCEPTION(\"No database connection.\");\n"
    execute += "    }\n"
    execute += "\n"
    execute += "    char *msgError = NULL;\n"
    execute += "    bool correct = true;\n"
    execute += "    if( sqlite3_exec(m_database, script.c_str(), NULL, NULL, &msgError)!=SQLITE_OK ){\n"
    execute += "        LOG_ERROR(\"[CDAOFactorySQLite::executeScript] Error in SQL: \\\"%s\\\" --> \\\"%s\\\"\", script.c_str(), msgError);\n"
    execute += "        sqlite3_free(msgError);\n"
    execute += "        correct = false;\n"
    execute += "    }\n"
    execute += "    return correct;\n"
    execute += "}\n\n"
    return execute

  def renderExecuteScriptFile(self) :
    execute  = "bool CDAOFactorySQLite::executeScriptFile(const char *scriptFile)\n"
    execute += "{\n"
    execute += "    if( m_database==NULL ){\n"
    execute += "        throw PFEXCEPTION(\"[CDAOFactorySQLite::executeScriptFile] No database connection.\");\n"
    execute += "    }\n"
    execute += "\n"
    execute += "    char                c;\n"
    execute += "    std::ostringstream  sql;\n"
    execute += "    std::ifstream       script(scriptFile);\n"
    execute += "    if( script.fail() ){\n"
    execute += "        LOG_ERROR(\"[CDAOFactorySQLite::executeScriptFile] Error opening the script file: '%s'\", scriptFile);\n"
    execute += "        return false;\n"
    execute += "    }\n"
    execute += "\n"
    execute += "    while( script.good() ){\n"
    execute += "        c = (char) script.get();\n"
    execute += "        if( c!='\\r' && c!='\\n' && script.good() ){\n"
    execute += "            sql << c;\n"
    execute += "        }else{\n"
    execute += "            sql << ' ';\n"
    execute += "        }\n"
    execute += "    }\n"
    execute += "    script.close();\n"
    execute += "\n"
    execute += "    return executeScript(sql.str());\n"
    execute += "}\n\n"
    return execute

  def renderTransactionCPP(self, klasses) :
    transaction = "bool CDAOFactorySQLite::beginTransaction()\n"
    transaction+= "{\n"
    transaction+= "    if( m_database==NULL ){\n"
    transaction+= "        throw PFEXCEPTION(\"No database connection.\");\n"
    transaction+= "    }\n"
    transaction+= "\n"
    transaction+= "    char *msgError = NULL;\n"
    transaction+= "    bool correct = true;\n"
    transaction+= "    if( sqlite3_exec(m_database, \"BEGIN TRANSACTION;\", NULL, NULL, &msgError)!=SQLITE_OK ){\n"
    transaction+= "        LOG_ERROR(\"Error in 'BEGIN TRANSACTION;': \\\"%s\\\"\", msgError);\n"
    transaction+= "        sqlite3_free(msgError);\n"
    transaction+= "        correct = false;\n"
    transaction+= "    }\n"
    transaction+= "    return correct;\n"
    transaction+= "}\n\n"
    transaction+= "bool CDAOFactorySQLite::commit()\n"
    transaction+= "{\n"
    transaction+= "    if( m_database==NULL ){\n"
    transaction+= "        throw PFEXCEPTION(\"No database connection.\");\n"
    transaction+= "    }\n"
    transaction+= "\n"
    transaction+= "    char *msgError = NULL;\n"
    transaction+= "    bool correct = true;\n"
    transaction+= "    if( sqlite3_exec(m_database, \"COMMIT;\", NULL, NULL, &msgError)!=SQLITE_OK ){\n"
    transaction+= "        LOG_ERROR(\"Error in 'COMMIT;': \\\"%s\\\"\", msgError);\n"
    transaction+= "        sqlite3_free(msgError);\n"
    transaction+= "        correct = false;\n"
    transaction+= "    }\n"
    transaction+= "    return correct;\n"
    transaction+= "}\n\n"
    transaction+= "bool CDAOFactorySQLite::rollback()\n"
    transaction+= "{\n"
    transaction+= "    if( m_database==NULL ){\n"
    transaction+= "        throw PFEXCEPTION(\"No database connection.\");\n"
    transaction+= "    }\n"
    transaction+= "\n"
    transaction+= "    char *msgError = NULL;\n"
    transaction+= "    bool correct = true;\n"
    transaction+= "    if( sqlite3_exec(m_database, \"ROLLBACK;\", NULL, NULL, &msgError)!=SQLITE_OK ){\n"
    transaction+= "        LOG_ERROR(\"Error in 'ROLLBACK;': \\\"%s\\\"\", msgError);\n"
    transaction+= "        sqlite3_free(msgError);\n"
    transaction+= "        correct = false;\n"
    transaction+= "    }\n"
    transaction+= "    return correct;\n"
    transaction+= "}\n\n"
    return transaction

  def renderSaveCPP(self, klasses) :
    save  = "void CDAOFactorySQLite::save()\n"
    save += "{\n"
    save +="    // Closing temp database\n"
    for klass in klasses.keys() :
      save += "    m_"+self.attributeName(klass)+"DAOSQLite->setSQLite(NULL);\n"
    save += "\n"
    save += "    sqlite3_close(m_database);\n"
    save += "    m_database = NULL;\n"
    save += "\n"
    save += "    // Copying data to original database\n"
    save += "    copyFile(m_filepath_tmp, m_filepath);\n"
    save += "    LOG_DEBUG(\"[CDAOFactorySQLite::save] SQLite Database saved: '%s'\", m_filepath.c_str());\n"
    save += "\n"
    save += "    // Reopening temp database\n"
    save += "    if( sqlite3_open(m_filepath_tmp.c_str(), &m_database )!=SQLITE_OK ){\n"
    save += "        sqlite3_close(m_database);\n"
    save += "        m_database = NULL;\n"
    save += "        throw PFEXCEPTION(\"Can't open database file: '%s' --> '%s'\", m_filepath_tmp.c_str(), sqlite3_errmsg(m_database));\n"
    save += "    }\n"
    save += "\n"
    for klass in klasses.keys() :
      save += "    m_"+self.attributeName(klass)+"DAOSQLite->setSQLite(m_database);\n"
    save += "}\n\n"
    return save

  def renderGettersCPP(self, klasses) :
    getters = ""
    for klass in klasses.keys() :
      getters += self.interfaceName(klass)+"DAO* CDAOFactorySQLite::get"+self.interfaceName(klass)+"DAO()\n"
      getters += "{\n"
      getters += "    return m_"+self.attributeName(klass)+"DAOSQLite;\n"
      getters += "}\n\n"
    return getters

  def renderCopyFileCPP(self) :
    copyFile  = "void CDAOFactorySQLite::copyFile(const std::string &origin, const std::string &destination)\n"
    copyFile += "{\n"
    copyFile += "    std::ifstream  is(origin.c_str(),       std::ifstream::in|std::ifstream::binary);\n"
    copyFile += "    std::ofstream  os(destination.c_str(),  std::ofstream::out|std::ofstream::binary|std::ofstream::trunc);\n"
    copyFile += "    if( is.is_open() && os.is_open() ){\n"
    copyFile += "        LOG_DEBUG(\"[CDAOFactorySQLite::copyFile] Copying files: is:'%s' os:'%s'\", origin.c_str(), destination.c_str());\n"
    copyFile += "\n"
    copyFile += "        char buffer[4096]; // 4KBytes\n"
    copyFile += "        int  nBytes;\n"
    copyFile += "        while( !is.eof() ){\n"
    copyFile += "            is.read(buffer, sizeof(buffer));\n"
    copyFile += "            nBytes = is.gcount();\n"
    copyFile += "            os.write(buffer, nBytes);\n"
    copyFile += "        }\n"
    copyFile += "    }\n"
    copyFile += "\n"
    copyFile += "    is.close();\n"
    copyFile += "    os.close();\n"
    copyFile += "}\n\n"
    return copyFile

  def renderCPP(self, path, klasses) :
    file = open(os.path.join(path, "db/sqlite/dao/factory/CDAOFactorySQLite.cpp"), "w")
    file.write(self.license())
    file.write("#include <iostream>\n")
    file.write("#include <fstream>\n")
    file.write("#include <sstream>\n")
    file.write("\n")
    file.write("#include \"CDAOFactorySQLite.h\"\n")
    file.write("#include \"../../../../../exceptions/PFException.h\"\n")
    file.write("#include \"../../../../../utils/CLog.h\"\n")
    file.write("\n")
    file.write(self.renderConstructorCPP(klasses))
    file.write(self.renderDestructorCPP(klasses))
    file.write(self.renderExecuteScript())
    file.write(self.renderExecuteScriptFile())
    file.write(self.renderTransactionCPP(klasses))
    file.write(self.renderSaveCPP(klasses))
    file.write(self.renderGettersCPP(klasses))
    file.write(self.renderCopyFileCPP())
    file.close()

  def render(self, path, klasses) :
    self.renderH(path, klasses)
    self.renderCPP(path, klasses)


##################################################################################################
# CClassDAOEntityRenderer ########################################################################
##################################################################################################
class CClassDAOEntityRenderer(UtilRenderer) :
  def renderH(self, path, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    iClassDAO = self.interfaceName(klass.name)+"DAO"
    file      = open(os.path.join(path, "db/sqlite/dao/entity/"+cClassDAO+".h"), "w")
    file.write(self.license())
    file.write(self.defineH(cClassDAO))
    file.write("#include <string>\n")
    file.write("#include <vector>\n")
    file.write("#include <sqlite3.h>\n")
    file.write("\n")
    file.write("#include \"../../../bean/"+cClass+".h\"\n")
    file.write("#include \"../../../dao/"+iClassDAO+".h\"\n")
    file.write("\n")
    file.write("class "+cClassDAO+" : public "+iClassDAO+"\n")
    file.write("{\n")
    file.write("public:\n")
    file.write("    "+cClassDAO+"(sqlite3 *database);\n")
    file.write("    virtual ~"+cClassDAO+"();\n")
    file.write("\n")
    file.write("    void setSQLite(sqlite3 *database);\n")
    file.write("\n")
    if klass.stereotype!="VIEW" :
      file.write("    virtual bool deleteReg("+cClass+" *reg);\n")
      file.write("    virtual bool insertReg("+cClass+" *reg);\n")
      file.write("    virtual bool updateReg("+cClass+" *reg);\n")
      file.write("\n")
    file.write("    virtual void freeVector(std::vector<"+cClass+"*>* vector);\n")
    file.write("\n")
    file.write("protected:\n")
    file.write("    "+cClass+"* loadRegister(const std::string &sql);\n")
    file.write("    std::vector<"+cClass+"*>* loadVector(const std::string &sql);\n")
    file.write("\n")
    file.write("private:\n")
    file.write("    bool exec(const std::string &sql);\n")
    file.write("    static int callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn );\n")
    file.write("    static int callbackVector(void *object, int nColumns, char **vColumn, char **sColumn );\n")
    file.write("\n")
    file.write("    sqlite3 *m_database;\n")
    file.write("\n")
    file.write("};\n")
    file.write(self.endDefineH(cClassDAO))
    file.close()

  def renderConstructorCPP(self, klass) :
    cClassDAO    = self.className(klass.name)+"DAOSQLiteEntity"
    constructor  = cClassDAO+"::"+cClassDAO+"(sqlite3 *database)\n"
    constructor += "{\n"
    constructor += "    m_database = database;\n"
    constructor += "}\n\n"
    return constructor

  def renderDestructorCPP(self, klass) :
    cClassDAO   = self.className(klass.name)+"DAOSQLiteEntity"
    destructor  = cClassDAO+"::~"+cClassDAO+"()\n"
    destructor += "{\n"
    destructor += "}\n\n"
    return destructor

  def renderSetSQLiteCPP(self, klass) :
    cClassDAO  = self.className(klass.name)+"DAOSQLiteEntity"
    setSQLite  = "void "+cClassDAO+"::setSQLite(sqlite3 *database)\n"
    setSQLite += "{\n"
    setSQLite += "    m_database = database;\n"
    setSQLite += "}\n\n"
    return setSQLite

  def renderDeleteRegCPP(self, klass) :
    pk        = self.primaryKey(klass)
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    delete    = "bool "+cClassDAO+"::deleteReg("+cClass+" *reg)\n"
    delete   += "{\n"
    delete   += "    std::string sql(\"DELETE FROM "+klass.name+" WHERE "+pk+"=\");\n"
    delete   += "    sql += \"'\"+reg->get"+self.attributeName(pk)+"_str()+\"'\";\n"
    delete   += "    return exec(sql);\n"
    delete   += "}\n\n"
    return delete

  def renderInsertRegCPP(self, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    insert    = "bool "+cClassDAO+"::insertReg("+cClass+" *reg)\n"
    insert   += "{\n"
    insert   += "    std::string sql(\"INSERT INTO "+klass.name+" ("
    coma      = ""
    for a in klass.attributes.keys() :
      if a[:2]!="X_" or a[:4]=="X_FK" :
        insert += coma+a
        coma=","
    insert += ") VALUES (\");\n"
    coma = ""
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if a[:2]!="X_" or a[:4]=="X_FK" :
        insert += "    sql += (reg->get"+self.attributeName(a)+"_str()==\"\")?\""+coma+"NULL\":\""+coma+"'\"+reg->get"+self.attributeName(a)+"_str()+\"'\";\n"
        coma = ","
    insert += "    sql += \")\";\n"
    insert += "    if( exec(sql) ){\n"
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if a[:2]=="X_" and a[:4]!="X_FK" :
        insert += "        reg->set"+self.attributeName(a)+"(sqlite3_last_insert_rowid(m_database));\n"
    insert += "        return true;\n"
    insert += "    }else{\n"
    insert += "        return false;\n"
    insert += "    }\n"
    insert += "}\n\n"
    return insert

  def renderUpdateRegCPP(self, klass) :
    pk        = self.primaryKey(klass)
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    update    = "bool "+cClassDAO+"::updateReg("+cClass+" *reg)\n"
    update   += "{\n"
    update   += "    std::string sql(\"UPDATE "+klass.name+" SET \");\n"
    coma      = " "
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      update += "    sql += (reg->get"+self.attributeName(a)+"_str()==\"\")?\""+coma+a+"=NULL\":\""+coma+a+"='\"+reg->get"+self.attributeName(a)+"_str()+\"'\";\n"
      coma = ","
    update += "    sql += \" WHERE "+pk+"='\"+reg->get"+self.attributeName(pk)+"_str()+\"'\";\n"
    update += "    return exec(sql);\n"
    update += "}\n\n"
    return update

  def renderFreeVectorCPP(self, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    fVector   = "void "+cClassDAO+"::freeVector(std::vector<"+cClass+"*>* vector )\n"
    fVector  += "{\n"
    fVector  += "    std::vector<"+cClass+"*>::iterator it;\n"
    fVector  += "    for( it=vector->begin(); it!=vector->end(); it++ ){\n"
    fVector  += "        delete (*it);\n"
    fVector  += "        (*it) = NULL;\n"
    fVector  += "    }\n"
    fVector  += "    delete vector;\n"
    fVector  += "}\n\n"
    return fVector

  def renderLoadRegisterCPP(self, klass) :
    cClass     = self.className(klass.name)
    cClassDAO  = self.className(klass.name)+"DAOSQLiteEntity"
    lRegister  = cClass+"* "+cClassDAO+"::loadRegister(const std::string &sql)\n"
    lRegister += "{\n"
    lRegister += "    if( m_database==NULL ){\n"
    lRegister += "        throw PFEXCEPTION(\"No database connection.\");\n"
    lRegister += "    }\n"
    lRegister += "\n"
    lRegister += "    char *msgError = NULL;\n"
    lRegister += "    "+cClass+" *destiny = new "+cClass+"();\n"
    lRegister += "    int result = sqlite3_exec(m_database, sql.c_str(), callbackRegister, destiny, &msgError);\n"
    lRegister += "    if( result!=SQLITE_OK && result!=SQLITE_ABORT ){\n"
    lRegister += "        LOG_ERROR(\"Error in SQL: \\\"%s\\\" --> \\\"%s\\\"\", sql.c_str(), msgError);\n"
    lRegister += "    }\n"
    lRegister += "    if( msgError!=NULL ){ \n"
    lRegister += "        sqlite3_free(msgError);\n"
    lRegister += "    }\n"
    lRegister += "    return destiny;\n"
    lRegister += "}\n\n"
    return lRegister

  def renderLoadVectorCPP(self, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    lVector   = "std::vector<"+cClass+"*> * "+cClassDAO+"::loadVector(const std::string &sql)\n"
    lVector  += "{\n"
    lVector  += "    if( m_database==NULL ){\n"
    lVector  += "        throw PFEXCEPTION(\"No database connection.\");\n"
    lVector  += "    }\n"
    lVector  += "\n"
    lVector  += "    char *msgError = NULL;\n"
    lVector  += "    std::vector<"+cClass+"*> *container = new std::vector<"+cClass+"*>;\n"
    lVector  += "    int result = sqlite3_exec(m_database, sql.c_str(), callbackVector, container, &msgError);\n"
    lVector  += "    if( result!=SQLITE_OK ){\n"
    lVector  += "        LOG_ERROR(\"Error in SQL: \\\"%s\\\" --> \\\"%s\\\"\", sql.c_str(), msgError);\n"
    lVector  += "    }\n"
    lVector  += "    if( msgError!=NULL ){ \n"
    lVector  += "        sqlite3_free(msgError);\n"
    lVector  += "    }\n"
    lVector  += "    return container;\n"
    lVector  += "}\n\n"
    return lVector

  def renderExecCPP(self, klass) :
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    ex  = "bool "+cClassDAO+"::exec(const std::string &sql)\n"
    ex += "{\n"
    ex += "    if( m_database==NULL ){\n"
    ex += "        throw PFEXCEPTION(\"No database connection.\");\n"
    ex += "    }\n"
    ex += "\n"
    ex += "    char *msgError = NULL;\n"
    ex += "    bool correct = true;\n"
    ex += "    int result = sqlite3_exec(m_database, sql.c_str(), NULL, NULL, &msgError);\n"
    ex += "    if( result!=SQLITE_OK ){\n"
    ex += "        LOG_ERROR(\"Error in SQL: \\\"%s\\\" --> \\\"%s\\\"\", sql.c_str(), msgError);\n"
    ex += "        correct = false;\n"
    ex += "    }\n"
    ex += "    if( msgError!=NULL ){ \n"
    ex += "        sqlite3_free(msgError);\n"
    ex += "    }\n"
    ex += "    return correct;\n"
    ex += "}\n\n"
    return ex

  def renderCallbackRegisterCPP(self, klass) :
    cClass      = self.className(klass.name)
    cClassDAO   = self.className(klass.name)+"DAOSQLiteEntity"
    cbRegister  = "int "+cClassDAO+"::callbackRegister(void *object, int nColumns, char **vColumn, char **sColumn)\n"
    cbRegister += "{\n"
    cbRegister += "    if( object!=NULL ){\n"
    cbRegister += "        "+cClass+" *destiny = ("+cClass+"*)object;\n"
    cbRegister += "        for( int i=0; i<nColumns; i++ ){\n"
    elseif = ""
    for a in klass.attributes.keys() :
      cbRegister += "            "+elseif+"if( strcmp(sColumn[i], \""+a+"\")==0 ){\n"
      cbRegister += "                destiny->set"+self.attributeName(a)+"_str((vColumn[i]==NULL)?\"\":vColumn[i]);\n"
      elseif = "}else "
    cbRegister += "            }\n"
    cbRegister += "        }\n"
    cbRegister += "    }\n"
    cbRegister += "    return -1; // Abort, don't load more rows\n"
    cbRegister += "}\n\n"
    return cbRegister

  def renderCallbackVectorCPP(self, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    cbVector  = "int "+cClassDAO+"::callbackVector(void *object, int nColumns, char **vColumn, char **sColumn)\n"
    cbVector += "{\n"
    cbVector += "    if( object!=NULL ){\n"
    cbVector += "        std::vector<"+cClass+"*> *container = (std::vector<"+cClass+"*> *)object;\n"
    cbVector += "        "+cClass+" *destiny = new "+cClass+"();\n"
    cbVector += "        for( int i=0; i<nColumns; i++ ){\n"
    elseif = ""
    for a in klass.attributes.keys() :
      cbVector += "            "+elseif+"if( strcmp(sColumn[i], \""+a+"\")==0 ){\n"
      cbVector += "                destiny->set"+self.attributeName(a)+"_str((vColumn[i]==NULL)?\"\":vColumn[i]);\n"
      elseif = "}else "
    cbVector += "            }\n"
    cbVector += "        }\n"
    cbVector += "        container->push_back(destiny);\n"
    cbVector += "    }\n"
    cbVector += "    return 0; // All OK\n"
    cbVector += "}\n\n"
    return cbVector

  def renderCPP(self, path, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLiteEntity"
    iClassDAO = self.interfaceName(klass.name)+"DAO"
    file      = open(os.path.join(path, "db/sqlite/dao/entity/"+cClassDAO+".cpp"), "w")
    file.write(self.license())
    file.write("#include <stdlib.h>\n")
    file.write("#include <string.h>\n")
    file.write("\n")
    file.write("#include \""+cClassDAO+".h\"\n")
    file.write("#include \"../../../../../exceptions/PFException.h\"\n")
    file.write("#include \"../../../../../utils/CLog.h\"\n")
    file.write("\n")
    file.write(self.renderConstructorCPP(klass))
    file.write(self.renderDestructorCPP(klass))
    file.write(self.renderSetSQLiteCPP(klass))
    if klass.stereotype!="VIEW" :
      file.write(self.renderDeleteRegCPP(klass))
      file.write(self.renderInsertRegCPP(klass))
      file.write(self.renderUpdateRegCPP(klass))
    file.write(self.renderFreeVectorCPP(klass))
    file.write(self.renderLoadRegisterCPP(klass))
    file.write(self.renderLoadVectorCPP(klass))
    file.write(self.renderExecCPP(klass))
    file.write(self.renderCallbackRegisterCPP(klass))
    file.write(self.renderCallbackVectorCPP(klass))
    file.close()

  def render(self, path, klass) :
    self.renderH(path, klass)
    self.renderCPP(path, klass)


##################################################################################################
# CClassDAORenderer ##############################################################################
##################################################################################################
class CClassDAORenderer(UtilRenderer) :
  def renderH(self, path, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLite"
    file = open(os.path.join(path, "db/sqlite/dao/"+cClassDAO+".h"), "w")
    file.write(self.license())
    file.write(self.defineH(cClassDAO))
    file.write("#include <string>\n")
    file.write("#include <sqlite3.h>\n")
    file.write("\n")
    file.write("#include \"entity/"+cClassDAO+"Entity.h\"\n")
    file.write("#include \"../../bean/"+cClass+".h\"\n")
    file.write("\n")
    file.write("class "+cClassDAO+" : public "+cClassDAO+"Entity\n")
    file.write("{\n")
    file.write("public:\n")
    file.write("    "+cClassDAO+"(sqlite3 *database);\n")
    file.write("    virtual ~"+cClassDAO+"();\n")
    file.write("\n")
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if a[:2]=="X_" :
        if t=="TEXT" :
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+");\n")
        elif t=="INTEGER" :
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(int "+self.attributeName(a)+");\n")
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+");\n")
        elif t=="DOUBLE" :
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(double "+self.attributeName(a)+");\n")
          file.write("    virtual "+cClass+"* findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+");\n")
    file.write("\n")
    file.write("};\n")
    file.write(self.endDefineH(cClassDAO))
    file.close()

  def renderConstructorCPP(self, klass) :
    cClassDAO    = self.className(klass.name)+"DAOSQLite"
    constructor  = cClassDAO+"::"+cClassDAO+"(sqlite3 *database)\n"
    constructor += "  : "+cClassDAO+"Entity(database)\n"
    constructor += "{\n"
    constructor += "}\n\n"
    return constructor

  def renderDestructorCPP(self, klass) :
    cClassDAO   = self.className(klass.name)+"DAOSQLite"
    destructor  = cClassDAO+"::~"+cClassDAO+"()\n"
    destructor += "{\n"
    destructor += "}\n\n"
    return destructor

  def renderFindMethodsCPP(self, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLite"
    find = ""
    for a in klass.attributes.keys() :
      t, v = klass.attributes[a]
      if a[:2]=="X_" :
        if t=="TEXT" :
          find += cClass+"* "+cClassDAO+"::findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+")\n"
          find += "{\n"
          find += "    std::string sql(\"SELECT * FROM "+klass.name+" WHERE \");\n"
          find += "    sql = sql+\""+a+"='\"+"+self.attributeName(a)+"+\"'\";\n"
          find += "    return loadRegister(sql);\n"
          find += "}\n\n"
        elif t=="INTEGER" :
          find += cClass+"* "+cClassDAO+"::findBy"+self.attributeName(a)+"(int "+self.attributeName(a)+")\n"
          find += "{\n"
          find += "    std::ostringstream stream;\n"
          find += "    stream << "+self.attributeName(a)+";\n"
          find += "    return findBy"+self.attributeName(a)+"(stream.str());\n"
          find += "}\n\n"
          find += cClass+"* "+cClassDAO+"::findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+")\n"
          find += "{\n"
          find += "    std::string sql(\"SELECT * FROM "+klass.name+" WHERE \");\n"
          find += "    sql = sql+\""+a+"='\"+"+self.attributeName(a)+"+\"'\";\n"
          find += "    return loadRegister(sql);\n"
          find += "}\n\n"
        elif t=="DOUBLE" :
          find += cClass+"* "+cClassDAO+"::findBy"+self.attributeName(a)+"(double "+self.attributeName(a)+")\n"
          find += "{\n"
          find += "    std::ostringstream stream;\n"
          find += "    stream << "+self.attributeName(a)+";\n"
          find += "    return findBy"+self.attributeName(a)+"(stream.str());\n"
          find += "}\n\n"
          find += cClass+"* "+cClassDAO+"::findBy"+self.attributeName(a)+"(const std::string &"+self.attributeName(a)+")\n"
          find += "{\n"
          find += "    std::string sql(\"SELECT * FROM "+klasses.name+" WHERE \");\n"
          find += "    sql = sql+\""+a+"='\"+"+self.attributeName(a)+"+\"'\";\n"
          find += "    return loadRegister(sql);\n"
          find += "}\n\n"
    return find

  def renderCPP(self, path, klass) :
    cClass    = self.className(klass.name)
    cClassDAO = self.className(klass.name)+"DAOSQLite"
    file = open(os.path.join(path, "db/sqlite/dao/"+cClassDAO+".cpp"), "w")
    file.write(self.license())
    file.write("#include <iostream>\n")
    file.write("#include <sstream>\n")
    file.write("\n")
    file.write("#include \""+cClassDAO+".h\"\n")
    file.write("\n")
    file.write(self.renderConstructorCPP(klass))
    file.write(self.renderDestructorCPP(klass))
    file.write(self.renderFindMethodsCPP(klass))
    file.close()

  def render(self, path, klass) :
    self.renderH(path, klass)
    self.renderCPP(path, klass)


##################################################################################################
# CSQLiteDDLRenderer #############################################################################
##################################################################################################
class CSQLiteDDLRenderer(UtilRenderer) :
  def renderTables(self, path, klasses) :
    file = open(os.path.join(path, "ddl/sqlite/tables.sql"), "w")
    for k in klasses.keys() :
      coma      = ""
      klass     = klasses[k]
      tableName = klass.name.upper()
      if klass.stereotype!="VIEW" :
        file.write("CREATE TABLE "+tableName+"\n")
        file.write("(\n")
        for a in klass.attributes.keys() :
          t, v = klass.attributes[a]
          if a[:2]=="X_" and a[:4]!="X_FK" :
            if t=="TEXT" :
              file.write("  "+coma+a.upper()+" TEXT PRIMARY KEY\n")
              coma=","
            elif t=="INTEGER" :
              file.write("  "+coma+a.upper()+" INTEGER PRIMARY KEY AUTOINCREMENT\n")
              coma=","
            elif t=="DOUBLE" :
              file.write("  "+coma+a.upper()+" REAL PRIMARY KEY\n")
              coma=","
            elif t=="DATE" :
              file.write("  "+coma+a.upper()+" TEXT PRIMARY KEY\n")
              coma=","
            elif t=="BOOLEAN" :
              file.write("  "+coma+a.upper()+" TEXT PRIMARY KEY\n")
              coma=","
          else :
            if t=="TEXT" :
              file.write("  "+coma+a.upper()+" TEXT\n")
              coma=","
            elif t=="INTEGER" :
              file.write("  "+coma+a.upper()+" INTEGER\n")
              coma=","
            elif t=="DOUBLE" :
              file.write("  "+coma+a.upper()+" REAL\n")
              coma=","
            elif t=="DATE" :
              file.write("  "+coma+a.upper()+" TEXT\n")
              coma=","
            elif t=="BOOLEAN" :
              file.write("  "+coma+a.upper()+" TEXT\n")
              coma=","
        file.write(");\n\n")

  def renderIndexes(self, path, klasses) :
    file = open(os.path.join(path, "ddl/sqlite/indexes.sql"), "w")
    for k in klasses.keys() :
      klass     = klasses[k]
      tableName = klass.name.upper()
      if klass.stereotype!="VIEW" :
        for a in klass.attributes.keys() :
            if a[:2]=="X_" :
                file.write("CREATE INDEX "+tableName+"_"+a.upper()+" ON "+tableName+" ("+a.upper()+");\n")

  def render(self, path, klasses) :
    self.renderTables(path, klasses)
    self.renderIndexes(path, klasses)


##################################################################################################
# Klass ##########################################################################################
##################################################################################################
class Klass :
  def __init__ (self, name) :
    self.name = name
    self.attributes = {}
    self.operations = {}
    self.comment = ""
    self.stereotype = ""
  def AddAttribute(self, name, type, visibility) :
    self.attributes[name] = (type, visibility)
  def AddOperation(self, name, type, visibility, params) :
    self.operations[name] = (type, visibility, params)
  def SetComment(self, s) :
    self.comment = s
  def SetStereoType(self, s) :
    self.stereotype = s


##################################################################################################
# DAORenderer ####################################################################################
##################################################################################################
class DAORenderer :
  "Implements the Object Renderer Interface and transforms diagram into its internal representation"
  def __init__ (self) :
    # an empty dictionary of classes
    self.klasses = {}
    self.filename = ""
    self.path = ""
    self.name = ""
    self.ext = ""

  def createDirectories(self) :
    try:
      os.makedirs(self.path+"/"+self.name+"/db/bean")
      os.makedirs(self.path+"/"+self.name+"/db/dao/factory")
      os.makedirs(self.path+"/"+self.name+"/db/sqlite/dao/entity")
      os.makedirs(self.path+"/"+self.name+"/db/sqlite/dao/factory")
      os.makedirs(self.path+"/"+self.name+"/ddl/sqlite")
    except:
#      dia.message("Directories already exists")
      print "Directories already exists"

  def parseData(self, data) :
    for layer in data.layers :
      # for the moment ignore layer info. But we could use this to spread accross different files
      for o in layer.objects :
        if o.type.name == "UML - Class" :
          #print o.properties["name"].value
          k = Klass (o.properties["name"].value)
          k.SetComment(o.properties["comment"].value)
          k.SetStereoType(o.properties["stereotype"].value)
          for op in o.properties["operations"].value :
            # op : a tuple with fixed placing, see: objects/UML/umloperations.c:umloperation_props
            # (name, type, comment, stereotype, visibility, inheritance_type, class_scope, params)
            params = []
            for par in op[8] :
              # par : again fixed placement, see objects/UML/umlparameter.c:umlparameter_props
              params.append((par[0], par[1]))
            k.AddOperation (op[0], op[1], op[4], params)
          #print o.properties["attributes"].value
          for attr in o.properties["attributes"].value :
            # see objects/UML/umlattributes.c:umlattribute_props
            #print "\t", attr[0], attr[1], attr[4]
            k.AddAttribute(attr[0], attr[1], attr[4])
          self.klasses[o.properties["name"].value] = k
        elif o.type.name == "UML - Generalization" :
          # could setup inheritance here
          pass
        elif o.type.name == "UML - Association" :
          # should already have got attributes relation by names
          pass
        # other UML objects which may be interesting
        # UML - Note, UML - LargePackage, UML - SmallPackage, UML - Dependency, ...

  def begin_render(self, data, filename) :
    self.filename = filename
    self.path     = os.path.dirname(filename)
    (self.name, self.ext) = os.path.splitext(os.path.basename(self.filename))

    self.parseData(data)
    self.createDirectories()

    IDAOFactoryRenderer().render(self.path+"/"+self.name, self.klasses)
    CDAOFactorySQLiteRenderer().render(self.path+"/"+self.name, self.klasses)

    for klass in self.klasses.keys() :
      IClassDAORenderer().render(self.path+"/"+self.name, self.klasses[klass])
      CBeanClassRenderer().render(self.path+"/"+self.name, self.klasses[klass])
      CClassDAOEntityRenderer().render(self.path+"/"+self.name, self.klasses[klass])
      CClassDAORenderer().render(self.path+"/"+self.name, self.klasses[klass])

    CSQLiteDDLRenderer().render(self.path+"/"+self.name, self.klasses)

  def end_render(self) :
    # without this we would accumulate info from every pass
    self.klasses = {}
    os.remove(self.filename)


# dia-python keeps a reference to the renderer class and uses it on demand
dia.register_export ("PyDia Code Generation (C++ DAO)", "cpp", DAORenderer())
