/***************************************************************************
                          job_synchronizewithdatabase.h  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JOB_SYNCHRONIZEWITHDATABASE_H
#define JOB_SYNCHRONIZEWITHDATABASE_H

#include "prokyon.h"

#define UPDATE_ONLY                            1
#define UPDATE_AND_READ_EXTERN_CHANGED_TRACKS  2 // --> parameter ONLY_NOT_INTERN_CHANGED, FORCE_REREAD
#define UPDATE_AND_WRITE_INTERN_CHANGED_TRACKS 3 // --> parameter ONLY_NOT_EXTERN_CHANGED, FORCE_WRITE
#define UPDATE_AND_SYNCHRONIZE                 4 // --> parameter PREFER_INTERN_CHANGED, PREFER_EXTERN_CHANGED

#define NO_PARAMETER                           0
#define ONLY_NOT_INTERN_CHANGED                1
#define FORCE_REREAD                           2
#define ONLY_NOT_EXTERN_CHANGED                3
#define FORCE_WRITE                            4
#define PREFER_INTERN_CHANGED                  5
#define PREFER_EXTERN_CHANGED                  6

#include "lvi_cddrive.h"
#include "lvi_smbshare.h"
#include "lvi_nfsexport.h"

#include "jobbasetagmanipulation.h"

class Job_SynchronizeWithDatabase : public JobBaseTagManipulation  {
 public: 
  Job_SynchronizeWithDatabase(int _modus, int _parameter = NO_PARAMETER);
  Job_SynchronizeWithDatabase(LVI_CDDrive *_drive, int _modus, int _parameter = NO_PARAMETER);
  Job_SynchronizeWithDatabase(LVI_SMBShare *_share, int _modus, int _parameter = NO_PARAMETER);
  Job_SynchronizeWithDatabase(LVI_NFSExport *_Export, int _modus, int _parameter = NO_PARAMETER);
  
  int type() { return JOB_SYNCHRONIZE_WITH_DATABASE; }
  
  int getMediumID();
  
  void run();
  
  ~Job_SynchronizeWithDatabase();
  
 private:
  int mediumType;
  int modus;
  int parameter;
  LVI_CDDrive *drive;
  LVI_SMBShare *share;
  LVI_NFSExport *Export;
};

#endif
