/***************************************************************************
                          tagger_taglib.h  -  description
                             -------------------
    begin                : Sun Feb 15 2004
    copyright            : (C) 2004 by Cord Horeis
    email                : kuddel@zipfelmuetzenparty.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGGER_TAGLIB_H
#define TAGGER_TAGLIB_H

#include "tagger.h"
#include <tag.h>
#include <mpegfile.h>
#include <id3v1tag.h>
#include <tstring.h>
#include <tbytevector.h>
#include <qtextcodec.h>

struct songProperties {
  QString   artist;
  QString   title;
  QString   album;
  int       tracknumber;
  uint      year;
  QString   genre;
  QString   comment;
};

struct audioProperties {
  int       version;
  int       layer;
  int       mode;
  int       bitrate;
  int       samplerate;
  int       length;
  int       size;
  int       mimetype;
};

class Tagger_TagLib {
public: 
  Tagger_TagLib();
  ~Tagger_TagLib();

  static bool getInfo(TRACK *track, bool lazyRead, const QString& fileExt);
  static bool getTagOnly(TRACK *track, const QString& fileExt);
  static bool writeInfo(TRACK *track, QString ext);


private:
  static bool setTrack(TRACK* track, songProperties* mySongProp); 
  static bool setAudioProperties(TRACK* track, audioProperties* myAudioProp); 

};

/**********************************************************************************
  ID3v1 technically isn't supposed to contain anything other than ISO-8859-1 ("Latin 1")
  next class is an "unsupported"  hack enabling non latin1 encoding in id3V1

class LocaleStringHandler : public TagLib::ID3v1::StringHandler
{ 
 public:
  LocaleStringHandler() : m_codec(QTextCodec::codecForName("utf8")) {}  // will convert to utf8

  virtual TagLib::String parse(const TagLib::ByteVector &data) const
    {
      qWarning(" parsing....");
      return QStringToTString(m_codec->toUnicode(data.data(), data.size()));
    }

  virtual TagLib::ByteVector render( const TagLib::String & s ) const
    {
      qWarning(" rendering....");
      QCString locallyEncoded = m_codec->fromUnicode( TStringToQString( s ) );  // convert to locale encoding
      return  TagLib::ByteVector::ByteVector( locallyEncoded, locallyEncoded.size() );
    }

 private:
  QTextCodec *m_codec;
};
******************************************************/

#endif
