/***************************************************************************
                          tagger.h  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAGGER_H
#define TAGGER_H

#include "prokyon.h"

#include <qfileinfo.h>

class Tagger {
public:
    Tagger();

    static bool isKnownFile(QFileInfo *fi);
    static bool isExtensionValid(TRACK *track);
    static bool getInfo(TRACK *track, bool lazyRead);
    static bool getTagOnly(TRACK *track);
    static bool writeInfo(TRACK *track);

    static QString getGenre(int genreNum);
    static QString getGenreAlpha(int alphaNum);
    static int genreToAlphaIndex(int genre);
    static int alphaToGenreIndex(int alpha);

    static QString getTypeAsString(TRACK *track);
    static QString getModeAsString(TRACK *track);
    static QString getSizeAsString(TRACK *track);

    static void stripWhiteSpace(TRACK *track, const QString &type);

    ~Tagger();
};

#endif
