#!/bin/bash
# This script converts the directory/file structure of how cscmail used 
# to store its messages/header files to the new format of no msg/hdr dirs
# and combined hdr/msg files into one msg file ...
# Maher Awamy <muhri@muhri.net>

echo " Please backup your ~/.cscmail dir prior to running this script !! "
echo " If you have not backed up your data, press crtl C and do it now"
echo " To continue press <enter> "
read
echo ""
echo " ... Entering CSCMail directory ... "
echo ""
cd ~/.cscmail
echo "" > blank
echo " ... Conversion in progress ... "
for i in `find ~/.cscmail -type d -name msg` ;do cd $i ; mv *.msg ../ ; cd ../hdr ; mv *.hdr ../ ; done
rm -fr `find ~/.cscmail -type d -name msg -print`
rm -fr `find ~/.cscmail -type d -name hdr -print`
for i in `find ~/.cscmail -type f -name *.hdr -print`
do
cat $i ~/.cscmail/blank $(echo $i | sed 's/hdr/msg/') > $(echo $i | sed 's/hdr/new/')
done
rm -fr `find ~/.cscmail -type f -name *.hdr -print`
rm -fr `find ~/.cscmail -type f -name *.msg -print`
rm -fr blank
for i in `find ~/.cscmail -type f -name *.new`;  { mv $i $(echo $i | sed 's/new/msg/'); }
echo ""
echo " .... Conversion done !! .... "
echo " .... Creating tmp and sig dirs and moving you sigs there .... "
mkdir ~/.cscmail/tmp
mkdir ~/.cscmail/sig
mv ~/*.sig ~/.cscmail/sig
echo " ... Completely done now !!!  ... "
