/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2002 Hewlett-Packard Company
 *
 * Author: Keith Fish, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: runner.c,v 1.1 2002/05/15 21:44:58 type2 Exp $ */

/*
 * Math functions CPU chewer.
 */

#include <stdio.h>
#include <math.h>

double r1(double a, double b)
{
	double retval;

	if (a > 0.01)
		retval = b / sin(a);
	else
		retval = b * sin(a);
	return(retval);
}

double r2(double a, double b)
{
	double retval;

	if (b > 0.02)
		retval = a - sin(b);
	else
		retval = a + sin(b);
	return(retval);
}

main(int argc, char *argv[])
{
	unsigned long i;
	double f = 0.1;
        int quiet=0;

	i = 0;

        if (argc>1) {
            if (strstr("q", argv[1])) quiet=1;
        }

	while (f != 0.0) {
	    i++;
	    if (! (i & 0xfffff)) 
                if (!quiet)
                    printf("%ld - %lg\n", i, f);
	    f = r1(f, 1.0/f);
	    f = r2(f+0.1, f-0.2);
	}
	exit(0);   
}
