#ifndef SCREENSHOT_H
#define SCREENSHOT_H

#include <QPixmap>
#include <QDialog>
#include <QFtp>
#include <QUrl>

QT_BEGIN_NAMESPACE
class QGridLayout;
class QGroupBox;
class QHBoxLayout;
class QPushButton;
class QSpinBox;
class QVBoxLayout;
class QLabel;
class QProgressBar;
QT_END_NAMESPACE


class Screenshot : public QDialog
{
    Q_OBJECT

public:
	Screenshot(QString aUrl = "", QString aFileNameFormat = "pic-yyyyMMdd-hhmmss", QString aFormat = "png");
	~Screenshot();

	void setUrl(QString aUrl);
	void setFormat(QString aFormat);
	void setFileNameFormat(QString aFileNameFormat);

protected:
	void resizeEvent(QResizeEvent *event);

public slots:
	void shootScreen();

private slots:
	void saveScreenshot();
	void uploadScreenshot();
	void dataTransferProgress( qint64 done, qint64 total );
	void ftpCommandFinished(int commandId, bool error);

private:
	void createButtonsLayout();
	QPushButton *createButton(const QString &text, QWidget *receiver, const char *member);
	void updateScreenshotLabel();

	void uploadFtp();
	void uploadHttp();

	void showFtpError(QString error);

    QPixmap originalPixmap;

    QLabel *screenshotLabel;
    QPushButton *saveScreenshotButton;
	QPushButton *uploadScreenshotButton;
    QPushButton *quitScreenshotButton;

    QVBoxLayout *mainLayout;
    QGridLayout *optionsGroupBoxLayout;
    QHBoxLayout *buttonsLayout;
	QProgressBar *progressBar;

	QString url;
	QString format;
	QString fileNameFormat;
	QString fileName;

	QFtp *ftp;
	QUrl u;
	QByteArray ba;
};


#endif
