#include "boarddelegate.h"
#include "boardmodel.h"

#include <QPainter>

void BoardDelegate::paint(QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const
{
    BoardModel *model = (BoardModel*)index.model();
    QRect r = option.rect;
    QColor color = ((option.state & QStyle::State_Selected) && model->myMove && !model->gameState_) ?
                   QColor("#b5e3ff") : index.data(Qt::BackgroundColorRole).value<QColor>();
    painter->fillRect(r, color);

    QPixmap pix = qVariantValue<QPixmap>(index.data(Qt::DisplayRole));
    painter->drawPixmap(r, pix);
}

