#ifndef CLEANER_H
#define CLEANER_H

#include <QtGui>
#include "cleanerplugin.h"
#include "ui_cleaner.h"
#include "models.h"


class CleanerMainWindow : public QMainWindow
{
    Q_OBJECT

public:
        CleanerMainWindow(CleanerPlugin *cleaner);
        virtual ~CleanerMainWindow() {};
        int height_;
        int width_;

private:
        QString vCardDir_, historyDir_, homeDir_, profilesDir_;
        QAction *findHistory, *findVcards;
        void setContent();
        QLabel *sb1, *sb2, *sb3;
        bool clearDir(QString path);
        CleanerPlugin *cleaner_;
        Ui::CleanerMainWindow ui_;

        void createStatusBar();
        void updateStatusBar();
        void createMainMenu();
        QString picturesDir();
        QString avatarsDir();
        QString currentProfileDir();

        ClearingHistoryModel *historyModel_;
        ClearingVcardModel *vcardsModel_;
        ClearingAvatarModel *avatarModel_;
        ClearingOptionsModel *optionsModel_;
        ClearingProxyModel *proxyHistoryModel_, *proxyVcardsModel_;
        QSortFilterProxyModel *proxyAvatarModel_, *proxyOptionsModel_;

public slots:
        void resizeWindow(int, int);
        void showCleaner();

private slots:
        void deleteButtonPressed();
        void deleteVcards();
        void deleteHistory();
        void deleteAvatars();
        void deleteOptions();
        void filterEvent();
        void viewVcard(QModelIndex index);
        void viewHistory(QModelIndex index);
        void viewAvatar(QModelIndex index);
        void chooseProfileAct();
        void changeProfile(QString);
        void clearJuick();
        void clearBirhday();
        void currentTabChanged(int tab);
        void selectAll();
        void unselectAll();

protected:
        void closeEvent(QCloseEvent * event);
};


#endif // CLEANER_H
