#include "tooltip.h"

#include <QHBoxLayout>
#include <QCursor>

ToolTip::ToolTip(QString jid, bool checked, QObject* /*parent*/)
            : QFrame(0, Qt::ToolTip)
            , jid_(jid)
{
    setAttribute(Qt::WA_DeleteOnClose);
    QHBoxLayout *layout = new QHBoxLayout(this);
    box_ = new QCheckBox(tr("Watch for JID"));
    box_->setCheckState(checked ? Qt::Checked : Qt::Unchecked);
    layout->addWidget(box_);

    QPoint pos = QCursor::pos();
    pos.setX(pos.x() - 20);
    pos.setY(pos.y() - 20);
    move(pos);

    connect(box_, SIGNAL(stateChanged(int)), this, SLOT(stateChanged(int)));
}

void ToolTip::stateChanged(int state)
{
    if(state)
        emit check(jid_, true);
    else
        emit check(jid_, false);
}

void ToolTip::leaveEvent(QEvent *e)
{
    e->accept();
    close();
}

