#!/usr/bin/env bash
#######################################################################
#                                                                     #
#       Universal build script of Psi+ under Linux                    #
#       Универсальный скрипт сборки Psi+ под Linux                    #
#                                                                     #
#######################################################################

# REQUIREMENTS / ТРЕБОВАНИЯ

# In order to build Psi+ you must have next packages in your system
# Для сборки Psi+ вам понадобятся следующие пакеты
# git - vcs system / система контроля версий
# gcc - compiler / компилятор
# qt4 tools libraries and headers (most probably "dev" packages) / qt4 тулзы либы и хидеры (наверное "dev" пакеты)
# qca/QtCrypto - encryption libs / криптовальные либы
 


# OPTIONS / НАСТРОЙКИ

# build and store directory / каталог для сорсов и сборки
PSI_DIR="${HOME}/psi"

# icons for downloads / иконки для скачивания
ICONSETS="system clients activities moods affiliations"

# do git pull on psi git working copy on start
# обновляться с репозитория перед сборкой
#FORCE_REPO_UPDATE=1

# log of applying patches / лог применения патчей
PATCH_LOG="${PSI_DIR}/psipatch.log"

# do svn up on patches / обновлять патчи из svn
#FORCE_PATCH_UPDATE=1

# skip patches which applies with errors / пропускать глючные патчи
#SKIP_INVALID_PATCH=0

# configure options / опции скрипта configure
CONF_OPTS="${@:---prefix=/usr --enable-plugins}"

# install root / каталог куда устанавливать (полезно для пакаджеров)
INSTALL_ROOT="${INSTALL_ROOT:-/}"


[ ! -f libpsibuild.sh ] && {
  wget http://psi-dev.googlecode.com/svn/trunk/scripts/posix/libpsibuild.sh
  [ ! -f libpsibuild.sh ] && {
    echo "can't download libpsibuild.sh"
    exit 1
  }
}
. ./libpsibuild.sh
#############
# Go Go Go! #
#############
check_env
prepare_workspace
fetch_sources
prepare_sources
src_compile
pkg_install
